// Template Source: BaseMethodCollectionRequestBuilder.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.DriveItem;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

import com.microsoft.graph.requests.DriveSharedWithMeCollectionRequestBuilder;
import com.microsoft.graph.requests.DriveSharedWithMeCollectionRequest;
import com.microsoft.graph.requests.DriveSharedWithMeCollectionResponse;
import com.microsoft.graph.options.FunctionOption;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseFunctionCollectionRequestBuilder;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Drive Shared With Me Collection Request Builder.
 */
public class DriveSharedWithMeCollectionRequestBuilder extends BaseFunctionCollectionRequestBuilder<DriveItem, DriveSharedWithMeCollectionRequestBuilder, DriveSharedWithMeCollectionResponse, DriveSharedWithMeCollectionPage, DriveSharedWithMeCollectionRequest> {

    /**
     * The request builder for this collection of Drive
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public DriveSharedWithMeCollectionRequestBuilder(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, DriveSharedWithMeCollectionRequestBuilder.class, DriveSharedWithMeCollectionRequest.class);
    }
    /**
     * Creates the request
     *
     * @param requestOptions the options for this request
     * @return the DriveSharedWithMeCollectionRequest instance
     */
    @Override
    @Nonnull
    public DriveSharedWithMeCollectionRequest buildRequest(@Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        final DriveSharedWithMeCollectionRequest request = super.buildRequest(requestOptions);
        return request;
    }
}
