// Template Source: BaseMethodCollectionRequestBuilder.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.ResourceSpecificPermissionGrant;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

import com.microsoft.graph.requests.GroupCheckGrantedPermissionsForAppCollectionRequestBuilder;
import com.microsoft.graph.requests.GroupCheckGrantedPermissionsForAppCollectionRequest;
import com.microsoft.graph.requests.GroupCheckGrantedPermissionsForAppCollectionResponse;
import com.microsoft.graph.options.FunctionOption;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseActionCollectionRequestBuilder;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Group Check Granted Permissions For App Collection Request Builder.
 */
public class GroupCheckGrantedPermissionsForAppCollectionRequestBuilder extends BaseActionCollectionRequestBuilder<ResourceSpecificPermissionGrant, GroupCheckGrantedPermissionsForAppCollectionRequestBuilder, GroupCheckGrantedPermissionsForAppCollectionResponse, GroupCheckGrantedPermissionsForAppCollectionPage, GroupCheckGrantedPermissionsForAppCollectionRequest> {

    /**
     * The request builder for this collection of Group
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public GroupCheckGrantedPermissionsForAppCollectionRequestBuilder(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, GroupCheckGrantedPermissionsForAppCollectionRequestBuilder.class, GroupCheckGrantedPermissionsForAppCollectionRequest.class);
    }
    /**
     * Creates the request
     *
     * @param requestOptions the options for this request
     * @return the GroupCheckGrantedPermissionsForAppCollectionRequest instance
     */
    @Override
    @Nonnull
    public GroupCheckGrantedPermissionsForAppCollectionRequest buildRequest(@Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        final GroupCheckGrantedPermissionsForAppCollectionRequest request = super.buildRequest(requestOptions);
        return request;
    }
}
