// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.IdentityCustomUserFlowAttribute;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Identity Custom User Flow Attribute Request.
 */
public class IdentityCustomUserFlowAttributeRequest extends BaseRequest<IdentityCustomUserFlowAttribute> {
	
    /**
     * The request for the IdentityCustomUserFlowAttribute
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public IdentityCustomUserFlowAttributeRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, IdentityCustomUserFlowAttribute.class);
    }

    /**
     * Gets the IdentityCustomUserFlowAttribute from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<IdentityCustomUserFlowAttribute> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the IdentityCustomUserFlowAttribute from the service
     *
     * @return the IdentityCustomUserFlowAttribute from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public IdentityCustomUserFlowAttribute get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<IdentityCustomUserFlowAttribute> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public IdentityCustomUserFlowAttribute delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this IdentityCustomUserFlowAttribute with a source
     *
     * @param sourceIdentityCustomUserFlowAttribute the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<IdentityCustomUserFlowAttribute> patchAsync(@Nonnull final IdentityCustomUserFlowAttribute sourceIdentityCustomUserFlowAttribute) {
        return sendAsync(HttpMethod.PATCH, sourceIdentityCustomUserFlowAttribute);
    }

    /**
     * Patches this IdentityCustomUserFlowAttribute with a source
     *
     * @param sourceIdentityCustomUserFlowAttribute the source object with updates
     * @return the updated IdentityCustomUserFlowAttribute
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public IdentityCustomUserFlowAttribute patch(@Nonnull final IdentityCustomUserFlowAttribute sourceIdentityCustomUserFlowAttribute) throws ClientException {
        return send(HttpMethod.PATCH, sourceIdentityCustomUserFlowAttribute);
    }

    /**
     * Creates a IdentityCustomUserFlowAttribute with a new object
     *
     * @param newIdentityCustomUserFlowAttribute the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<IdentityCustomUserFlowAttribute> postAsync(@Nonnull final IdentityCustomUserFlowAttribute newIdentityCustomUserFlowAttribute) {
        return sendAsync(HttpMethod.POST, newIdentityCustomUserFlowAttribute);
    }

    /**
     * Creates a IdentityCustomUserFlowAttribute with a new object
     *
     * @param newIdentityCustomUserFlowAttribute the new object to create
     * @return the created IdentityCustomUserFlowAttribute
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public IdentityCustomUserFlowAttribute post(@Nonnull final IdentityCustomUserFlowAttribute newIdentityCustomUserFlowAttribute) throws ClientException {
        return send(HttpMethod.POST, newIdentityCustomUserFlowAttribute);
    }

    /**
     * Creates a IdentityCustomUserFlowAttribute with a new object
     *
     * @param newIdentityCustomUserFlowAttribute the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<IdentityCustomUserFlowAttribute> putAsync(@Nonnull final IdentityCustomUserFlowAttribute newIdentityCustomUserFlowAttribute) {
        return sendAsync(HttpMethod.PUT, newIdentityCustomUserFlowAttribute);
    }

    /**
     * Creates a IdentityCustomUserFlowAttribute with a new object
     *
     * @param newIdentityCustomUserFlowAttribute the object to create/update
     * @return the created IdentityCustomUserFlowAttribute
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public IdentityCustomUserFlowAttribute put(@Nonnull final IdentityCustomUserFlowAttribute newIdentityCustomUserFlowAttribute) throws ClientException {
        return send(HttpMethod.PUT, newIdentityCustomUserFlowAttribute);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public IdentityCustomUserFlowAttributeRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public IdentityCustomUserFlowAttributeRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

