// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.IdentityUserFlowAttributeAssignment;
import com.microsoft.graph.models.AssignmentOrder;
import com.microsoft.graph.requests.IdentityUserFlowAttributeWithReferenceRequestBuilder;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Identity User Flow Attribute Assignment Request.
 */
public class IdentityUserFlowAttributeAssignmentRequest extends BaseRequest<IdentityUserFlowAttributeAssignment> {
	
    /**
     * The request for the IdentityUserFlowAttributeAssignment
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public IdentityUserFlowAttributeAssignmentRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, IdentityUserFlowAttributeAssignment.class);
    }

    /**
     * Gets the IdentityUserFlowAttributeAssignment from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<IdentityUserFlowAttributeAssignment> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the IdentityUserFlowAttributeAssignment from the service
     *
     * @return the IdentityUserFlowAttributeAssignment from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public IdentityUserFlowAttributeAssignment get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<IdentityUserFlowAttributeAssignment> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public IdentityUserFlowAttributeAssignment delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this IdentityUserFlowAttributeAssignment with a source
     *
     * @param sourceIdentityUserFlowAttributeAssignment the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<IdentityUserFlowAttributeAssignment> patchAsync(@Nonnull final IdentityUserFlowAttributeAssignment sourceIdentityUserFlowAttributeAssignment) {
        return sendAsync(HttpMethod.PATCH, sourceIdentityUserFlowAttributeAssignment);
    }

    /**
     * Patches this IdentityUserFlowAttributeAssignment with a source
     *
     * @param sourceIdentityUserFlowAttributeAssignment the source object with updates
     * @return the updated IdentityUserFlowAttributeAssignment
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public IdentityUserFlowAttributeAssignment patch(@Nonnull final IdentityUserFlowAttributeAssignment sourceIdentityUserFlowAttributeAssignment) throws ClientException {
        return send(HttpMethod.PATCH, sourceIdentityUserFlowAttributeAssignment);
    }

    /**
     * Creates a IdentityUserFlowAttributeAssignment with a new object
     *
     * @param newIdentityUserFlowAttributeAssignment the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<IdentityUserFlowAttributeAssignment> postAsync(@Nonnull final IdentityUserFlowAttributeAssignment newIdentityUserFlowAttributeAssignment) {
        return sendAsync(HttpMethod.POST, newIdentityUserFlowAttributeAssignment);
    }

    /**
     * Creates a IdentityUserFlowAttributeAssignment with a new object
     *
     * @param newIdentityUserFlowAttributeAssignment the new object to create
     * @return the created IdentityUserFlowAttributeAssignment
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public IdentityUserFlowAttributeAssignment post(@Nonnull final IdentityUserFlowAttributeAssignment newIdentityUserFlowAttributeAssignment) throws ClientException {
        return send(HttpMethod.POST, newIdentityUserFlowAttributeAssignment);
    }

    /**
     * Creates a IdentityUserFlowAttributeAssignment with a new object
     *
     * @param newIdentityUserFlowAttributeAssignment the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<IdentityUserFlowAttributeAssignment> putAsync(@Nonnull final IdentityUserFlowAttributeAssignment newIdentityUserFlowAttributeAssignment) {
        return sendAsync(HttpMethod.PUT, newIdentityUserFlowAttributeAssignment);
    }

    /**
     * Creates a IdentityUserFlowAttributeAssignment with a new object
     *
     * @param newIdentityUserFlowAttributeAssignment the object to create/update
     * @return the created IdentityUserFlowAttributeAssignment
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public IdentityUserFlowAttributeAssignment put(@Nonnull final IdentityUserFlowAttributeAssignment newIdentityUserFlowAttributeAssignment) throws ClientException {
        return send(HttpMethod.PUT, newIdentityUserFlowAttributeAssignment);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public IdentityUserFlowAttributeAssignmentRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public IdentityUserFlowAttributeAssignmentRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

