// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.ImportedWindowsAutopilotDeviceIdentity;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Imported Windows Autopilot Device Identity Request.
 */
public class ImportedWindowsAutopilotDeviceIdentityRequest extends BaseRequest<ImportedWindowsAutopilotDeviceIdentity> {
	
    /**
     * The request for the ImportedWindowsAutopilotDeviceIdentity
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public ImportedWindowsAutopilotDeviceIdentityRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, ImportedWindowsAutopilotDeviceIdentity.class);
    }

    /**
     * Gets the ImportedWindowsAutopilotDeviceIdentity from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ImportedWindowsAutopilotDeviceIdentity> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the ImportedWindowsAutopilotDeviceIdentity from the service
     *
     * @return the ImportedWindowsAutopilotDeviceIdentity from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public ImportedWindowsAutopilotDeviceIdentity get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ImportedWindowsAutopilotDeviceIdentity> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public ImportedWindowsAutopilotDeviceIdentity delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this ImportedWindowsAutopilotDeviceIdentity with a source
     *
     * @param sourceImportedWindowsAutopilotDeviceIdentity the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ImportedWindowsAutopilotDeviceIdentity> patchAsync(@Nonnull final ImportedWindowsAutopilotDeviceIdentity sourceImportedWindowsAutopilotDeviceIdentity) {
        return sendAsync(HttpMethod.PATCH, sourceImportedWindowsAutopilotDeviceIdentity);
    }

    /**
     * Patches this ImportedWindowsAutopilotDeviceIdentity with a source
     *
     * @param sourceImportedWindowsAutopilotDeviceIdentity the source object with updates
     * @return the updated ImportedWindowsAutopilotDeviceIdentity
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public ImportedWindowsAutopilotDeviceIdentity patch(@Nonnull final ImportedWindowsAutopilotDeviceIdentity sourceImportedWindowsAutopilotDeviceIdentity) throws ClientException {
        return send(HttpMethod.PATCH, sourceImportedWindowsAutopilotDeviceIdentity);
    }

    /**
     * Creates a ImportedWindowsAutopilotDeviceIdentity with a new object
     *
     * @param newImportedWindowsAutopilotDeviceIdentity the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ImportedWindowsAutopilotDeviceIdentity> postAsync(@Nonnull final ImportedWindowsAutopilotDeviceIdentity newImportedWindowsAutopilotDeviceIdentity) {
        return sendAsync(HttpMethod.POST, newImportedWindowsAutopilotDeviceIdentity);
    }

    /**
     * Creates a ImportedWindowsAutopilotDeviceIdentity with a new object
     *
     * @param newImportedWindowsAutopilotDeviceIdentity the new object to create
     * @return the created ImportedWindowsAutopilotDeviceIdentity
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public ImportedWindowsAutopilotDeviceIdentity post(@Nonnull final ImportedWindowsAutopilotDeviceIdentity newImportedWindowsAutopilotDeviceIdentity) throws ClientException {
        return send(HttpMethod.POST, newImportedWindowsAutopilotDeviceIdentity);
    }

    /**
     * Creates a ImportedWindowsAutopilotDeviceIdentity with a new object
     *
     * @param newImportedWindowsAutopilotDeviceIdentity the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ImportedWindowsAutopilotDeviceIdentity> putAsync(@Nonnull final ImportedWindowsAutopilotDeviceIdentity newImportedWindowsAutopilotDeviceIdentity) {
        return sendAsync(HttpMethod.PUT, newImportedWindowsAutopilotDeviceIdentity);
    }

    /**
     * Creates a ImportedWindowsAutopilotDeviceIdentity with a new object
     *
     * @param newImportedWindowsAutopilotDeviceIdentity the object to create/update
     * @return the created ImportedWindowsAutopilotDeviceIdentity
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public ImportedWindowsAutopilotDeviceIdentity put(@Nonnull final ImportedWindowsAutopilotDeviceIdentity newImportedWindowsAutopilotDeviceIdentity) throws ClientException {
        return send(HttpMethod.PUT, newImportedWindowsAutopilotDeviceIdentity);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public ImportedWindowsAutopilotDeviceIdentityRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public ImportedWindowsAutopilotDeviceIdentityRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

