// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.ManagedAppPolicy;
import com.microsoft.graph.models.ManagedMobileApp;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Managed App Policy Request.
 */
public class ManagedAppPolicyRequest extends BaseRequest<ManagedAppPolicy> {
	
    /**
     * The request for the ManagedAppPolicy
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     * @param responseClass  the class of the response
     */
    public ManagedAppPolicyRequest(@Nonnull final String requestUrl,
            @Nonnull final IBaseClient<?> client,
            @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions,
            @Nonnull final Class<? extends ManagedAppPolicy> responseClass) {
        super(requestUrl, client, requestOptions, responseClass);
    }

    /**
     * The request for the ManagedAppPolicy
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public ManagedAppPolicyRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, ManagedAppPolicy.class);
    }

    /**
     * Gets the ManagedAppPolicy from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ManagedAppPolicy> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the ManagedAppPolicy from the service
     *
     * @return the ManagedAppPolicy from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public ManagedAppPolicy get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ManagedAppPolicy> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public ManagedAppPolicy delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this ManagedAppPolicy with a source
     *
     * @param sourceManagedAppPolicy the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ManagedAppPolicy> patchAsync(@Nonnull final ManagedAppPolicy sourceManagedAppPolicy) {
        return sendAsync(HttpMethod.PATCH, sourceManagedAppPolicy);
    }

    /**
     * Patches this ManagedAppPolicy with a source
     *
     * @param sourceManagedAppPolicy the source object with updates
     * @return the updated ManagedAppPolicy
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public ManagedAppPolicy patch(@Nonnull final ManagedAppPolicy sourceManagedAppPolicy) throws ClientException {
        return send(HttpMethod.PATCH, sourceManagedAppPolicy);
    }

    /**
     * Creates a ManagedAppPolicy with a new object
     *
     * @param newManagedAppPolicy the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ManagedAppPolicy> postAsync(@Nonnull final ManagedAppPolicy newManagedAppPolicy) {
        return sendAsync(HttpMethod.POST, newManagedAppPolicy);
    }

    /**
     * Creates a ManagedAppPolicy with a new object
     *
     * @param newManagedAppPolicy the new object to create
     * @return the created ManagedAppPolicy
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public ManagedAppPolicy post(@Nonnull final ManagedAppPolicy newManagedAppPolicy) throws ClientException {
        return send(HttpMethod.POST, newManagedAppPolicy);
    }

    /**
     * Creates a ManagedAppPolicy with a new object
     *
     * @param newManagedAppPolicy the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ManagedAppPolicy> putAsync(@Nonnull final ManagedAppPolicy newManagedAppPolicy) {
        return sendAsync(HttpMethod.PUT, newManagedAppPolicy);
    }

    /**
     * Creates a ManagedAppPolicy with a new object
     *
     * @param newManagedAppPolicy the object to create/update
     * @return the created ManagedAppPolicy
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public ManagedAppPolicy put(@Nonnull final ManagedAppPolicy newManagedAppPolicy) throws ClientException {
        return send(HttpMethod.PUT, newManagedAppPolicy);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public ManagedAppPolicyRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public ManagedAppPolicyRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

