// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.ManagedApp;
import com.microsoft.graph.models.MobileAppAssignment;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Managed App Request.
 */
public class ManagedAppRequest extends BaseRequest<ManagedApp> {
	
    /**
     * The request for the ManagedApp
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     * @param responseClass  the class of the response
     */
    public ManagedAppRequest(@Nonnull final String requestUrl,
            @Nonnull final IBaseClient<?> client,
            @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions,
            @Nonnull final Class<? extends ManagedApp> responseClass) {
        super(requestUrl, client, requestOptions, responseClass);
    }

    /**
     * The request for the ManagedApp
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public ManagedAppRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, ManagedApp.class);
    }

    /**
     * Gets the ManagedApp from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ManagedApp> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the ManagedApp from the service
     *
     * @return the ManagedApp from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public ManagedApp get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ManagedApp> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public ManagedApp delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this ManagedApp with a source
     *
     * @param sourceManagedApp the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ManagedApp> patchAsync(@Nonnull final ManagedApp sourceManagedApp) {
        return sendAsync(HttpMethod.PATCH, sourceManagedApp);
    }

    /**
     * Patches this ManagedApp with a source
     *
     * @param sourceManagedApp the source object with updates
     * @return the updated ManagedApp
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public ManagedApp patch(@Nonnull final ManagedApp sourceManagedApp) throws ClientException {
        return send(HttpMethod.PATCH, sourceManagedApp);
    }

    /**
     * Creates a ManagedApp with a new object
     *
     * @param newManagedApp the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ManagedApp> postAsync(@Nonnull final ManagedApp newManagedApp) {
        return sendAsync(HttpMethod.POST, newManagedApp);
    }

    /**
     * Creates a ManagedApp with a new object
     *
     * @param newManagedApp the new object to create
     * @return the created ManagedApp
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public ManagedApp post(@Nonnull final ManagedApp newManagedApp) throws ClientException {
        return send(HttpMethod.POST, newManagedApp);
    }

    /**
     * Creates a ManagedApp with a new object
     *
     * @param newManagedApp the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ManagedApp> putAsync(@Nonnull final ManagedApp newManagedApp) {
        return sendAsync(HttpMethod.PUT, newManagedApp);
    }

    /**
     * Creates a ManagedApp with a new object
     *
     * @param newManagedApp the object to create/update
     * @return the created ManagedApp
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public ManagedApp put(@Nonnull final ManagedApp newManagedApp) throws ClientException {
        return send(HttpMethod.PUT, newManagedApp);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public ManagedAppRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public ManagedAppRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

