// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.MessageRule;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Message Rule Request.
 */
public class MessageRuleRequest extends BaseRequest<MessageRule> {
	
    /**
     * The request for the MessageRule
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public MessageRuleRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, MessageRule.class);
    }

    /**
     * Gets the MessageRule from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<MessageRule> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the MessageRule from the service
     *
     * @return the MessageRule from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public MessageRule get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<MessageRule> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public MessageRule delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this MessageRule with a source
     *
     * @param sourceMessageRule the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<MessageRule> patchAsync(@Nonnull final MessageRule sourceMessageRule) {
        return sendAsync(HttpMethod.PATCH, sourceMessageRule);
    }

    /**
     * Patches this MessageRule with a source
     *
     * @param sourceMessageRule the source object with updates
     * @return the updated MessageRule
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public MessageRule patch(@Nonnull final MessageRule sourceMessageRule) throws ClientException {
        return send(HttpMethod.PATCH, sourceMessageRule);
    }

    /**
     * Creates a MessageRule with a new object
     *
     * @param newMessageRule the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<MessageRule> postAsync(@Nonnull final MessageRule newMessageRule) {
        return sendAsync(HttpMethod.POST, newMessageRule);
    }

    /**
     * Creates a MessageRule with a new object
     *
     * @param newMessageRule the new object to create
     * @return the created MessageRule
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public MessageRule post(@Nonnull final MessageRule newMessageRule) throws ClientException {
        return send(HttpMethod.POST, newMessageRule);
    }

    /**
     * Creates a MessageRule with a new object
     *
     * @param newMessageRule the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<MessageRule> putAsync(@Nonnull final MessageRule newMessageRule) {
        return sendAsync(HttpMethod.PUT, newMessageRule);
    }

    /**
     * Creates a MessageRule with a new object
     *
     * @param newMessageRule the object to create/update
     * @return the created MessageRule
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public MessageRule put(@Nonnull final MessageRule newMessageRule) throws ClientException {
        return send(HttpMethod.PUT, newMessageRule);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public MessageRuleRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public MessageRuleRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

