// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.MicrosoftStoreForBusinessApp;
import com.microsoft.graph.models.MobileAppAssignment;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Microsoft Store For Business App Request.
 */
public class MicrosoftStoreForBusinessAppRequest extends BaseRequest<MicrosoftStoreForBusinessApp> {
	
    /**
     * The request for the MicrosoftStoreForBusinessApp
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public MicrosoftStoreForBusinessAppRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, MicrosoftStoreForBusinessApp.class);
    }

    /**
     * Gets the MicrosoftStoreForBusinessApp from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<MicrosoftStoreForBusinessApp> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the MicrosoftStoreForBusinessApp from the service
     *
     * @return the MicrosoftStoreForBusinessApp from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public MicrosoftStoreForBusinessApp get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<MicrosoftStoreForBusinessApp> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public MicrosoftStoreForBusinessApp delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this MicrosoftStoreForBusinessApp with a source
     *
     * @param sourceMicrosoftStoreForBusinessApp the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<MicrosoftStoreForBusinessApp> patchAsync(@Nonnull final MicrosoftStoreForBusinessApp sourceMicrosoftStoreForBusinessApp) {
        return sendAsync(HttpMethod.PATCH, sourceMicrosoftStoreForBusinessApp);
    }

    /**
     * Patches this MicrosoftStoreForBusinessApp with a source
     *
     * @param sourceMicrosoftStoreForBusinessApp the source object with updates
     * @return the updated MicrosoftStoreForBusinessApp
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public MicrosoftStoreForBusinessApp patch(@Nonnull final MicrosoftStoreForBusinessApp sourceMicrosoftStoreForBusinessApp) throws ClientException {
        return send(HttpMethod.PATCH, sourceMicrosoftStoreForBusinessApp);
    }

    /**
     * Creates a MicrosoftStoreForBusinessApp with a new object
     *
     * @param newMicrosoftStoreForBusinessApp the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<MicrosoftStoreForBusinessApp> postAsync(@Nonnull final MicrosoftStoreForBusinessApp newMicrosoftStoreForBusinessApp) {
        return sendAsync(HttpMethod.POST, newMicrosoftStoreForBusinessApp);
    }

    /**
     * Creates a MicrosoftStoreForBusinessApp with a new object
     *
     * @param newMicrosoftStoreForBusinessApp the new object to create
     * @return the created MicrosoftStoreForBusinessApp
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public MicrosoftStoreForBusinessApp post(@Nonnull final MicrosoftStoreForBusinessApp newMicrosoftStoreForBusinessApp) throws ClientException {
        return send(HttpMethod.POST, newMicrosoftStoreForBusinessApp);
    }

    /**
     * Creates a MicrosoftStoreForBusinessApp with a new object
     *
     * @param newMicrosoftStoreForBusinessApp the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<MicrosoftStoreForBusinessApp> putAsync(@Nonnull final MicrosoftStoreForBusinessApp newMicrosoftStoreForBusinessApp) {
        return sendAsync(HttpMethod.PUT, newMicrosoftStoreForBusinessApp);
    }

    /**
     * Creates a MicrosoftStoreForBusinessApp with a new object
     *
     * @param newMicrosoftStoreForBusinessApp the object to create/update
     * @return the created MicrosoftStoreForBusinessApp
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public MicrosoftStoreForBusinessApp put(@Nonnull final MicrosoftStoreForBusinessApp newMicrosoftStoreForBusinessApp) throws ClientException {
        return send(HttpMethod.PUT, newMicrosoftStoreForBusinessApp);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public MicrosoftStoreForBusinessAppRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public MicrosoftStoreForBusinessAppRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

