// Template Source: BaseMethodRequestBuilder.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;
import com.microsoft.graph.requests.OnenotePagePreviewRequest;
import com.microsoft.graph.models.OnenotePage;
import com.microsoft.graph.models.OnenotePagePreview;
import com.microsoft.graph.http.BaseFunctionRequestBuilder;
import com.microsoft.graph.core.IBaseClient;
import com.google.gson.JsonElement;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Onenote Page Preview Request Builder.
 */
public class OnenotePagePreviewRequestBuilder extends BaseFunctionRequestBuilder<OnenotePagePreview> {

    /**
     * The request builder for this OnenotePagePreview
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public OnenotePagePreviewRequestBuilder(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }

    /**
     * Creates the OnenotePagePreviewRequest
     *
     * @param requestOptions the options for the request
     * @return the OnenotePagePreviewRequest instance
     */
    @Nonnull
    public OnenotePagePreviewRequest buildRequest(@Nullable final com.microsoft.graph.options.Option... requestOptions) {
        return buildRequest(getOptions(requestOptions));
    }

    /**
     * Creates the OnenotePagePreviewRequest with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for the request
     * @return the OnenotePagePreviewRequest instance
     */
    @Nonnull
    public OnenotePagePreviewRequest buildRequest(@Nonnull final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        final OnenotePagePreviewRequest request = new OnenotePagePreviewRequest(
                getRequestUrl(),
                getClient(),
                requestOptions);
        return request;
    }
}
