// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.OpenShiftChangeRequest;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Open Shift Change Request Request.
 */
public class OpenShiftChangeRequestRequest extends BaseRequest<OpenShiftChangeRequest> {
	
    /**
     * The request for the OpenShiftChangeRequest
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public OpenShiftChangeRequestRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, OpenShiftChangeRequest.class);
    }

    /**
     * Gets the OpenShiftChangeRequest from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<OpenShiftChangeRequest> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the OpenShiftChangeRequest from the service
     *
     * @return the OpenShiftChangeRequest from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public OpenShiftChangeRequest get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<OpenShiftChangeRequest> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public OpenShiftChangeRequest delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this OpenShiftChangeRequest with a source
     *
     * @param sourceOpenShiftChangeRequest the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<OpenShiftChangeRequest> patchAsync(@Nonnull final OpenShiftChangeRequest sourceOpenShiftChangeRequest) {
        return sendAsync(HttpMethod.PATCH, sourceOpenShiftChangeRequest);
    }

    /**
     * Patches this OpenShiftChangeRequest with a source
     *
     * @param sourceOpenShiftChangeRequest the source object with updates
     * @return the updated OpenShiftChangeRequest
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public OpenShiftChangeRequest patch(@Nonnull final OpenShiftChangeRequest sourceOpenShiftChangeRequest) throws ClientException {
        return send(HttpMethod.PATCH, sourceOpenShiftChangeRequest);
    }

    /**
     * Creates a OpenShiftChangeRequest with a new object
     *
     * @param newOpenShiftChangeRequest the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<OpenShiftChangeRequest> postAsync(@Nonnull final OpenShiftChangeRequest newOpenShiftChangeRequest) {
        return sendAsync(HttpMethod.POST, newOpenShiftChangeRequest);
    }

    /**
     * Creates a OpenShiftChangeRequest with a new object
     *
     * @param newOpenShiftChangeRequest the new object to create
     * @return the created OpenShiftChangeRequest
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public OpenShiftChangeRequest post(@Nonnull final OpenShiftChangeRequest newOpenShiftChangeRequest) throws ClientException {
        return send(HttpMethod.POST, newOpenShiftChangeRequest);
    }

    /**
     * Creates a OpenShiftChangeRequest with a new object
     *
     * @param newOpenShiftChangeRequest the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<OpenShiftChangeRequest> putAsync(@Nonnull final OpenShiftChangeRequest newOpenShiftChangeRequest) {
        return sendAsync(HttpMethod.PUT, newOpenShiftChangeRequest);
    }

    /**
     * Creates a OpenShiftChangeRequest with a new object
     *
     * @param newOpenShiftChangeRequest the object to create/update
     * @return the created OpenShiftChangeRequest
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public OpenShiftChangeRequest put(@Nonnull final OpenShiftChangeRequest newOpenShiftChangeRequest) throws ClientException {
        return send(HttpMethod.PUT, newOpenShiftChangeRequest);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public OpenShiftChangeRequestRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public OpenShiftChangeRequestRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

