// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.Post;
import com.microsoft.graph.models.Recipient;
import com.microsoft.graph.requests.AttachmentCollectionRequestBuilder;
import com.microsoft.graph.requests.AttachmentRequestBuilder;
import com.microsoft.graph.requests.ExtensionCollectionRequestBuilder;
import com.microsoft.graph.requests.ExtensionRequestBuilder;
import com.microsoft.graph.requests.PostRequestBuilder;
import com.microsoft.graph.requests.MultiValueLegacyExtendedPropertyCollectionRequestBuilder;
import com.microsoft.graph.requests.MultiValueLegacyExtendedPropertyRequestBuilder;
import com.microsoft.graph.requests.SingleValueLegacyExtendedPropertyCollectionRequestBuilder;
import com.microsoft.graph.requests.SingleValueLegacyExtendedPropertyRequestBuilder;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Post Request.
 */
public class PostRequest extends BaseRequest<Post> {
	
    /**
     * The request for the Post
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public PostRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, Post.class);
    }

    /**
     * Gets the Post from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Post> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the Post from the service
     *
     * @return the Post from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public Post get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Post> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public Post delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this Post with a source
     *
     * @param sourcePost the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Post> patchAsync(@Nonnull final Post sourcePost) {
        return sendAsync(HttpMethod.PATCH, sourcePost);
    }

    /**
     * Patches this Post with a source
     *
     * @param sourcePost the source object with updates
     * @return the updated Post
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public Post patch(@Nonnull final Post sourcePost) throws ClientException {
        return send(HttpMethod.PATCH, sourcePost);
    }

    /**
     * Creates a Post with a new object
     *
     * @param newPost the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Post> postAsync(@Nonnull final Post newPost) {
        return sendAsync(HttpMethod.POST, newPost);
    }

    /**
     * Creates a Post with a new object
     *
     * @param newPost the new object to create
     * @return the created Post
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public Post post(@Nonnull final Post newPost) throws ClientException {
        return send(HttpMethod.POST, newPost);
    }

    /**
     * Creates a Post with a new object
     *
     * @param newPost the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Post> putAsync(@Nonnull final Post newPost) {
        return sendAsync(HttpMethod.PUT, newPost);
    }

    /**
     * Creates a Post with a new object
     *
     * @param newPost the object to create/update
     * @return the created Post
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public Post put(@Nonnull final Post newPost) throws ClientException {
        return send(HttpMethod.PUT, newPost);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public PostRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public PostRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

