// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.PrintDocument;
import com.microsoft.graph.models.PrintDocumentUploadProperties;
import com.microsoft.graph.models.UploadSession;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Print Document Request.
 */
public class PrintDocumentRequest extends BaseRequest<PrintDocument> {
	
    /**
     * The request for the PrintDocument
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public PrintDocumentRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, PrintDocument.class);
    }

    /**
     * Gets the PrintDocument from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<PrintDocument> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the PrintDocument from the service
     *
     * @return the PrintDocument from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public PrintDocument get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<PrintDocument> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public PrintDocument delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this PrintDocument with a source
     *
     * @param sourcePrintDocument the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<PrintDocument> patchAsync(@Nonnull final PrintDocument sourcePrintDocument) {
        return sendAsync(HttpMethod.PATCH, sourcePrintDocument);
    }

    /**
     * Patches this PrintDocument with a source
     *
     * @param sourcePrintDocument the source object with updates
     * @return the updated PrintDocument
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public PrintDocument patch(@Nonnull final PrintDocument sourcePrintDocument) throws ClientException {
        return send(HttpMethod.PATCH, sourcePrintDocument);
    }

    /**
     * Creates a PrintDocument with a new object
     *
     * @param newPrintDocument the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<PrintDocument> postAsync(@Nonnull final PrintDocument newPrintDocument) {
        return sendAsync(HttpMethod.POST, newPrintDocument);
    }

    /**
     * Creates a PrintDocument with a new object
     *
     * @param newPrintDocument the new object to create
     * @return the created PrintDocument
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public PrintDocument post(@Nonnull final PrintDocument newPrintDocument) throws ClientException {
        return send(HttpMethod.POST, newPrintDocument);
    }

    /**
     * Creates a PrintDocument with a new object
     *
     * @param newPrintDocument the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<PrintDocument> putAsync(@Nonnull final PrintDocument newPrintDocument) {
        return sendAsync(HttpMethod.PUT, newPrintDocument);
    }

    /**
     * Creates a PrintDocument with a new object
     *
     * @param newPrintDocument the object to create/update
     * @return the created PrintDocument
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public PrintDocument put(@Nonnull final PrintDocument newPrintDocument) throws ClientException {
        return send(HttpMethod.PUT, newPrintDocument);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public PrintDocumentRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public PrintDocumentRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

