// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.TeamsAsyncOperation;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Teams Async Operation Request.
 */
public class TeamsAsyncOperationRequest extends BaseRequest<TeamsAsyncOperation> {
	
    /**
     * The request for the TeamsAsyncOperation
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public TeamsAsyncOperationRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, TeamsAsyncOperation.class);
    }

    /**
     * Gets the TeamsAsyncOperation from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<TeamsAsyncOperation> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the TeamsAsyncOperation from the service
     *
     * @return the TeamsAsyncOperation from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public TeamsAsyncOperation get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<TeamsAsyncOperation> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public TeamsAsyncOperation delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this TeamsAsyncOperation with a source
     *
     * @param sourceTeamsAsyncOperation the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<TeamsAsyncOperation> patchAsync(@Nonnull final TeamsAsyncOperation sourceTeamsAsyncOperation) {
        return sendAsync(HttpMethod.PATCH, sourceTeamsAsyncOperation);
    }

    /**
     * Patches this TeamsAsyncOperation with a source
     *
     * @param sourceTeamsAsyncOperation the source object with updates
     * @return the updated TeamsAsyncOperation
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public TeamsAsyncOperation patch(@Nonnull final TeamsAsyncOperation sourceTeamsAsyncOperation) throws ClientException {
        return send(HttpMethod.PATCH, sourceTeamsAsyncOperation);
    }

    /**
     * Creates a TeamsAsyncOperation with a new object
     *
     * @param newTeamsAsyncOperation the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<TeamsAsyncOperation> postAsync(@Nonnull final TeamsAsyncOperation newTeamsAsyncOperation) {
        return sendAsync(HttpMethod.POST, newTeamsAsyncOperation);
    }

    /**
     * Creates a TeamsAsyncOperation with a new object
     *
     * @param newTeamsAsyncOperation the new object to create
     * @return the created TeamsAsyncOperation
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public TeamsAsyncOperation post(@Nonnull final TeamsAsyncOperation newTeamsAsyncOperation) throws ClientException {
        return send(HttpMethod.POST, newTeamsAsyncOperation);
    }

    /**
     * Creates a TeamsAsyncOperation with a new object
     *
     * @param newTeamsAsyncOperation the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<TeamsAsyncOperation> putAsync(@Nonnull final TeamsAsyncOperation newTeamsAsyncOperation) {
        return sendAsync(HttpMethod.PUT, newTeamsAsyncOperation);
    }

    /**
     * Creates a TeamsAsyncOperation with a new object
     *
     * @param newTeamsAsyncOperation the object to create/update
     * @return the created TeamsAsyncOperation
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public TeamsAsyncOperation put(@Nonnull final TeamsAsyncOperation newTeamsAsyncOperation) throws ClientException {
        return send(HttpMethod.PUT, newTeamsAsyncOperation);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public TeamsAsyncOperationRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public TeamsAsyncOperationRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

