// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.UnmuteParticipantOperation;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Unmute Participant Operation Request.
 */
public class UnmuteParticipantOperationRequest extends BaseRequest<UnmuteParticipantOperation> {
	
    /**
     * The request for the UnmuteParticipantOperation
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public UnmuteParticipantOperationRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, UnmuteParticipantOperation.class);
    }

    /**
     * Gets the UnmuteParticipantOperation from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<UnmuteParticipantOperation> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the UnmuteParticipantOperation from the service
     *
     * @return the UnmuteParticipantOperation from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public UnmuteParticipantOperation get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<UnmuteParticipantOperation> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public UnmuteParticipantOperation delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this UnmuteParticipantOperation with a source
     *
     * @param sourceUnmuteParticipantOperation the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<UnmuteParticipantOperation> patchAsync(@Nonnull final UnmuteParticipantOperation sourceUnmuteParticipantOperation) {
        return sendAsync(HttpMethod.PATCH, sourceUnmuteParticipantOperation);
    }

    /**
     * Patches this UnmuteParticipantOperation with a source
     *
     * @param sourceUnmuteParticipantOperation the source object with updates
     * @return the updated UnmuteParticipantOperation
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public UnmuteParticipantOperation patch(@Nonnull final UnmuteParticipantOperation sourceUnmuteParticipantOperation) throws ClientException {
        return send(HttpMethod.PATCH, sourceUnmuteParticipantOperation);
    }

    /**
     * Creates a UnmuteParticipantOperation with a new object
     *
     * @param newUnmuteParticipantOperation the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<UnmuteParticipantOperation> postAsync(@Nonnull final UnmuteParticipantOperation newUnmuteParticipantOperation) {
        return sendAsync(HttpMethod.POST, newUnmuteParticipantOperation);
    }

    /**
     * Creates a UnmuteParticipantOperation with a new object
     *
     * @param newUnmuteParticipantOperation the new object to create
     * @return the created UnmuteParticipantOperation
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public UnmuteParticipantOperation post(@Nonnull final UnmuteParticipantOperation newUnmuteParticipantOperation) throws ClientException {
        return send(HttpMethod.POST, newUnmuteParticipantOperation);
    }

    /**
     * Creates a UnmuteParticipantOperation with a new object
     *
     * @param newUnmuteParticipantOperation the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<UnmuteParticipantOperation> putAsync(@Nonnull final UnmuteParticipantOperation newUnmuteParticipantOperation) {
        return sendAsync(HttpMethod.PUT, newUnmuteParticipantOperation);
    }

    /**
     * Creates a UnmuteParticipantOperation with a new object
     *
     * @param newUnmuteParticipantOperation the object to create/update
     * @return the created UnmuteParticipantOperation
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public UnmuteParticipantOperation put(@Nonnull final UnmuteParticipantOperation newUnmuteParticipantOperation) throws ClientException {
        return send(HttpMethod.PUT, newUnmuteParticipantOperation);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public UnmuteParticipantOperationRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public UnmuteParticipantOperationRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

