// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.UserConsentRequest;
import com.microsoft.graph.models.ConsentRequestFilterByCurrentUserOptions;
import com.microsoft.graph.requests.ApprovalRequestBuilder;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the User Consent Request Request.
 */
public class UserConsentRequestRequest extends BaseRequest<UserConsentRequest> {
	
    /**
     * The request for the UserConsentRequest
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public UserConsentRequestRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, UserConsentRequest.class);
    }

    /**
     * Gets the UserConsentRequest from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<UserConsentRequest> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the UserConsentRequest from the service
     *
     * @return the UserConsentRequest from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public UserConsentRequest get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<UserConsentRequest> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public UserConsentRequest delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this UserConsentRequest with a source
     *
     * @param sourceUserConsentRequest the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<UserConsentRequest> patchAsync(@Nonnull final UserConsentRequest sourceUserConsentRequest) {
        return sendAsync(HttpMethod.PATCH, sourceUserConsentRequest);
    }

    /**
     * Patches this UserConsentRequest with a source
     *
     * @param sourceUserConsentRequest the source object with updates
     * @return the updated UserConsentRequest
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public UserConsentRequest patch(@Nonnull final UserConsentRequest sourceUserConsentRequest) throws ClientException {
        return send(HttpMethod.PATCH, sourceUserConsentRequest);
    }

    /**
     * Creates a UserConsentRequest with a new object
     *
     * @param newUserConsentRequest the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<UserConsentRequest> postAsync(@Nonnull final UserConsentRequest newUserConsentRequest) {
        return sendAsync(HttpMethod.POST, newUserConsentRequest);
    }

    /**
     * Creates a UserConsentRequest with a new object
     *
     * @param newUserConsentRequest the new object to create
     * @return the created UserConsentRequest
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public UserConsentRequest post(@Nonnull final UserConsentRequest newUserConsentRequest) throws ClientException {
        return send(HttpMethod.POST, newUserConsentRequest);
    }

    /**
     * Creates a UserConsentRequest with a new object
     *
     * @param newUserConsentRequest the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<UserConsentRequest> putAsync(@Nonnull final UserConsentRequest newUserConsentRequest) {
        return sendAsync(HttpMethod.PUT, newUserConsentRequest);
    }

    /**
     * Creates a UserConsentRequest with a new object
     *
     * @param newUserConsentRequest the object to create/update
     * @return the created UserConsentRequest
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public UserConsentRequest put(@Nonnull final UserConsentRequest newUserConsentRequest) throws ClientException {
        return send(HttpMethod.PUT, newUserConsentRequest);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public UserConsentRequestRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public UserConsentRequestRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

