// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.Windows10EnterpriseModernAppManagementConfiguration;
import com.microsoft.graph.models.DeviceConfigurationAssignment;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Windows10Enterprise Modern App Management Configuration Request.
 */
public class Windows10EnterpriseModernAppManagementConfigurationRequest extends BaseRequest<Windows10EnterpriseModernAppManagementConfiguration> {
	
    /**
     * The request for the Windows10EnterpriseModernAppManagementConfiguration
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public Windows10EnterpriseModernAppManagementConfigurationRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, Windows10EnterpriseModernAppManagementConfiguration.class);
    }

    /**
     * Gets the Windows10EnterpriseModernAppManagementConfiguration from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Windows10EnterpriseModernAppManagementConfiguration> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the Windows10EnterpriseModernAppManagementConfiguration from the service
     *
     * @return the Windows10EnterpriseModernAppManagementConfiguration from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public Windows10EnterpriseModernAppManagementConfiguration get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Windows10EnterpriseModernAppManagementConfiguration> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public Windows10EnterpriseModernAppManagementConfiguration delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this Windows10EnterpriseModernAppManagementConfiguration with a source
     *
     * @param sourceWindows10EnterpriseModernAppManagementConfiguration the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Windows10EnterpriseModernAppManagementConfiguration> patchAsync(@Nonnull final Windows10EnterpriseModernAppManagementConfiguration sourceWindows10EnterpriseModernAppManagementConfiguration) {
        return sendAsync(HttpMethod.PATCH, sourceWindows10EnterpriseModernAppManagementConfiguration);
    }

    /**
     * Patches this Windows10EnterpriseModernAppManagementConfiguration with a source
     *
     * @param sourceWindows10EnterpriseModernAppManagementConfiguration the source object with updates
     * @return the updated Windows10EnterpriseModernAppManagementConfiguration
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public Windows10EnterpriseModernAppManagementConfiguration patch(@Nonnull final Windows10EnterpriseModernAppManagementConfiguration sourceWindows10EnterpriseModernAppManagementConfiguration) throws ClientException {
        return send(HttpMethod.PATCH, sourceWindows10EnterpriseModernAppManagementConfiguration);
    }

    /**
     * Creates a Windows10EnterpriseModernAppManagementConfiguration with a new object
     *
     * @param newWindows10EnterpriseModernAppManagementConfiguration the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Windows10EnterpriseModernAppManagementConfiguration> postAsync(@Nonnull final Windows10EnterpriseModernAppManagementConfiguration newWindows10EnterpriseModernAppManagementConfiguration) {
        return sendAsync(HttpMethod.POST, newWindows10EnterpriseModernAppManagementConfiguration);
    }

    /**
     * Creates a Windows10EnterpriseModernAppManagementConfiguration with a new object
     *
     * @param newWindows10EnterpriseModernAppManagementConfiguration the new object to create
     * @return the created Windows10EnterpriseModernAppManagementConfiguration
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public Windows10EnterpriseModernAppManagementConfiguration post(@Nonnull final Windows10EnterpriseModernAppManagementConfiguration newWindows10EnterpriseModernAppManagementConfiguration) throws ClientException {
        return send(HttpMethod.POST, newWindows10EnterpriseModernAppManagementConfiguration);
    }

    /**
     * Creates a Windows10EnterpriseModernAppManagementConfiguration with a new object
     *
     * @param newWindows10EnterpriseModernAppManagementConfiguration the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Windows10EnterpriseModernAppManagementConfiguration> putAsync(@Nonnull final Windows10EnterpriseModernAppManagementConfiguration newWindows10EnterpriseModernAppManagementConfiguration) {
        return sendAsync(HttpMethod.PUT, newWindows10EnterpriseModernAppManagementConfiguration);
    }

    /**
     * Creates a Windows10EnterpriseModernAppManagementConfiguration with a new object
     *
     * @param newWindows10EnterpriseModernAppManagementConfiguration the object to create/update
     * @return the created Windows10EnterpriseModernAppManagementConfiguration
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public Windows10EnterpriseModernAppManagementConfiguration put(@Nonnull final Windows10EnterpriseModernAppManagementConfiguration newWindows10EnterpriseModernAppManagementConfiguration) throws ClientException {
        return send(HttpMethod.PUT, newWindows10EnterpriseModernAppManagementConfiguration);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public Windows10EnterpriseModernAppManagementConfigurationRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public Windows10EnterpriseModernAppManagementConfigurationRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

