// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.WindowsInformationProtectionAppLearningSummary;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Windows Information Protection App Learning Summary Request.
 */
public class WindowsInformationProtectionAppLearningSummaryRequest extends BaseRequest<WindowsInformationProtectionAppLearningSummary> {
	
    /**
     * The request for the WindowsInformationProtectionAppLearningSummary
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public WindowsInformationProtectionAppLearningSummaryRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, WindowsInformationProtectionAppLearningSummary.class);
    }

    /**
     * Gets the WindowsInformationProtectionAppLearningSummary from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<WindowsInformationProtectionAppLearningSummary> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the WindowsInformationProtectionAppLearningSummary from the service
     *
     * @return the WindowsInformationProtectionAppLearningSummary from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public WindowsInformationProtectionAppLearningSummary get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<WindowsInformationProtectionAppLearningSummary> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public WindowsInformationProtectionAppLearningSummary delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this WindowsInformationProtectionAppLearningSummary with a source
     *
     * @param sourceWindowsInformationProtectionAppLearningSummary the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<WindowsInformationProtectionAppLearningSummary> patchAsync(@Nonnull final WindowsInformationProtectionAppLearningSummary sourceWindowsInformationProtectionAppLearningSummary) {
        return sendAsync(HttpMethod.PATCH, sourceWindowsInformationProtectionAppLearningSummary);
    }

    /**
     * Patches this WindowsInformationProtectionAppLearningSummary with a source
     *
     * @param sourceWindowsInformationProtectionAppLearningSummary the source object with updates
     * @return the updated WindowsInformationProtectionAppLearningSummary
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public WindowsInformationProtectionAppLearningSummary patch(@Nonnull final WindowsInformationProtectionAppLearningSummary sourceWindowsInformationProtectionAppLearningSummary) throws ClientException {
        return send(HttpMethod.PATCH, sourceWindowsInformationProtectionAppLearningSummary);
    }

    /**
     * Creates a WindowsInformationProtectionAppLearningSummary with a new object
     *
     * @param newWindowsInformationProtectionAppLearningSummary the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<WindowsInformationProtectionAppLearningSummary> postAsync(@Nonnull final WindowsInformationProtectionAppLearningSummary newWindowsInformationProtectionAppLearningSummary) {
        return sendAsync(HttpMethod.POST, newWindowsInformationProtectionAppLearningSummary);
    }

    /**
     * Creates a WindowsInformationProtectionAppLearningSummary with a new object
     *
     * @param newWindowsInformationProtectionAppLearningSummary the new object to create
     * @return the created WindowsInformationProtectionAppLearningSummary
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public WindowsInformationProtectionAppLearningSummary post(@Nonnull final WindowsInformationProtectionAppLearningSummary newWindowsInformationProtectionAppLearningSummary) throws ClientException {
        return send(HttpMethod.POST, newWindowsInformationProtectionAppLearningSummary);
    }

    /**
     * Creates a WindowsInformationProtectionAppLearningSummary with a new object
     *
     * @param newWindowsInformationProtectionAppLearningSummary the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<WindowsInformationProtectionAppLearningSummary> putAsync(@Nonnull final WindowsInformationProtectionAppLearningSummary newWindowsInformationProtectionAppLearningSummary) {
        return sendAsync(HttpMethod.PUT, newWindowsInformationProtectionAppLearningSummary);
    }

    /**
     * Creates a WindowsInformationProtectionAppLearningSummary with a new object
     *
     * @param newWindowsInformationProtectionAppLearningSummary the object to create/update
     * @return the created WindowsInformationProtectionAppLearningSummary
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public WindowsInformationProtectionAppLearningSummary put(@Nonnull final WindowsInformationProtectionAppLearningSummary newWindowsInformationProtectionAppLearningSummary) throws ClientException {
        return send(HttpMethod.PUT, newWindowsInformationProtectionAppLearningSummary);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public WindowsInformationProtectionAppLearningSummaryRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public WindowsInformationProtectionAppLearningSummaryRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

