// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.WorkbookFunctions;
import com.microsoft.graph.models.WorkbookFunctionResult;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Workbook Functions Request.
 */
public class WorkbookFunctionsRequest extends BaseRequest<WorkbookFunctions> {
	
    /**
     * The request for the WorkbookFunctions
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public WorkbookFunctionsRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, WorkbookFunctions.class);
    }

    /**
     * Gets the WorkbookFunctions from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<WorkbookFunctions> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the WorkbookFunctions from the service
     *
     * @return the WorkbookFunctions from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public WorkbookFunctions get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<WorkbookFunctions> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public WorkbookFunctions delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this WorkbookFunctions with a source
     *
     * @param sourceWorkbookFunctions the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<WorkbookFunctions> patchAsync(@Nonnull final WorkbookFunctions sourceWorkbookFunctions) {
        return sendAsync(HttpMethod.PATCH, sourceWorkbookFunctions);
    }

    /**
     * Patches this WorkbookFunctions with a source
     *
     * @param sourceWorkbookFunctions the source object with updates
     * @return the updated WorkbookFunctions
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public WorkbookFunctions patch(@Nonnull final WorkbookFunctions sourceWorkbookFunctions) throws ClientException {
        return send(HttpMethod.PATCH, sourceWorkbookFunctions);
    }

    /**
     * Creates a WorkbookFunctions with a new object
     *
     * @param newWorkbookFunctions the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<WorkbookFunctions> postAsync(@Nonnull final WorkbookFunctions newWorkbookFunctions) {
        return sendAsync(HttpMethod.POST, newWorkbookFunctions);
    }

    /**
     * Creates a WorkbookFunctions with a new object
     *
     * @param newWorkbookFunctions the new object to create
     * @return the created WorkbookFunctions
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public WorkbookFunctions post(@Nonnull final WorkbookFunctions newWorkbookFunctions) throws ClientException {
        return send(HttpMethod.POST, newWorkbookFunctions);
    }

    /**
     * Creates a WorkbookFunctions with a new object
     *
     * @param newWorkbookFunctions the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<WorkbookFunctions> putAsync(@Nonnull final WorkbookFunctions newWorkbookFunctions) {
        return sendAsync(HttpMethod.PUT, newWorkbookFunctions);
    }

    /**
     * Creates a WorkbookFunctions with a new object
     *
     * @param newWorkbookFunctions the object to create/update
     * @return the created WorkbookFunctions
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public WorkbookFunctions put(@Nonnull final WorkbookFunctions newWorkbookFunctions) throws ClientException {
        return send(HttpMethod.PUT, newWorkbookFunctions);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public WorkbookFunctionsRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public WorkbookFunctionsRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

