/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.Entity;
import com.microsoft.graph.models.Status;
import com.microsoft.graph.models.UserActivity;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class ActivityHistoryItem
extends Entity
implements Parsable {
    @Nonnull
    public static ActivityHistoryItem createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new ActivityHistoryItem();
    }

    @Nullable
    public Integer getActiveDurationSeconds() {
        return (Integer)this.backingStore.get("activeDurationSeconds");
    }

    @Nullable
    public UserActivity getActivity() {
        return (UserActivity)this.backingStore.get("activity");
    }

    @Nullable
    public OffsetDateTime getCreatedDateTime() {
        return (OffsetDateTime)this.backingStore.get("createdDateTime");
    }

    @Nullable
    public OffsetDateTime getExpirationDateTime() {
        return (OffsetDateTime)this.backingStore.get("expirationDateTime");
    }

    @Override
    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("activeDurationSeconds", n -> this.setActiveDurationSeconds(n.getIntegerValue()));
        deserializerMap.put("activity", n -> this.setActivity((UserActivity)n.getObjectValue(UserActivity::createFromDiscriminatorValue)));
        deserializerMap.put("createdDateTime", n -> this.setCreatedDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("expirationDateTime", n -> this.setExpirationDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("lastActiveDateTime", n -> this.setLastActiveDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("lastModifiedDateTime", n -> this.setLastModifiedDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("startedDateTime", n -> this.setStartedDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("status", n -> this.setStatus((Status)n.getEnumValue(Status::forValue)));
        deserializerMap.put("userTimezone", n -> this.setUserTimezone(n.getStringValue()));
        return deserializerMap;
    }

    @Nullable
    public OffsetDateTime getLastActiveDateTime() {
        return (OffsetDateTime)this.backingStore.get("lastActiveDateTime");
    }

    @Nullable
    public OffsetDateTime getLastModifiedDateTime() {
        return (OffsetDateTime)this.backingStore.get("lastModifiedDateTime");
    }

    @Nullable
    public OffsetDateTime getStartedDateTime() {
        return (OffsetDateTime)this.backingStore.get("startedDateTime");
    }

    @Nullable
    public Status getStatus() {
        return (Status)((Object)this.backingStore.get("status"));
    }

    @Nullable
    public String getUserTimezone() {
        return (String)this.backingStore.get("userTimezone");
    }

    @Override
    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeIntegerValue("activeDurationSeconds", this.getActiveDurationSeconds());
        writer.writeObjectValue("activity", (Parsable)this.getActivity(), new Parsable[0]);
        writer.writeOffsetDateTimeValue("createdDateTime", this.getCreatedDateTime());
        writer.writeOffsetDateTimeValue("expirationDateTime", this.getExpirationDateTime());
        writer.writeOffsetDateTimeValue("lastActiveDateTime", this.getLastActiveDateTime());
        writer.writeOffsetDateTimeValue("lastModifiedDateTime", this.getLastModifiedDateTime());
        writer.writeOffsetDateTimeValue("startedDateTime", this.getStartedDateTime());
        writer.writeEnumValue("status", (Enum)this.getStatus());
        writer.writeStringValue("userTimezone", this.getUserTimezone());
    }

    public void setActiveDurationSeconds(@Nullable Integer value) {
        this.backingStore.set("activeDurationSeconds", (Object)value);
    }

    public void setActivity(@Nullable UserActivity value) {
        this.backingStore.set("activity", (Object)value);
    }

    public void setCreatedDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("createdDateTime", (Object)value);
    }

    public void setExpirationDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("expirationDateTime", (Object)value);
    }

    public void setLastActiveDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("lastActiveDateTime", (Object)value);
    }

    public void setLastModifiedDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("lastModifiedDateTime", (Object)value);
    }

    public void setStartedDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("startedDateTime", (Object)value);
    }

    public void setStatus(@Nullable Status value) {
        this.backingStore.set("status", (Object)value);
    }

    public void setUserTimezone(@Nullable String value) {
        this.backingStore.set("userTimezone", (Object)value);
    }
}

