/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.ActionState;
import com.microsoft.graph.models.DeleteUserFromSharedAppleDeviceActionResult;
import com.microsoft.graph.models.LocateDeviceActionResult;
import com.microsoft.graph.models.RemoteLockActionResult;
import com.microsoft.graph.models.ResetPasscodeActionResult;
import com.microsoft.graph.models.RotateBitLockerKeysDeviceActionResult;
import com.microsoft.graph.models.WindowsDefenderScanActionResult;
import com.microsoft.kiota.serialization.AdditionalDataHolder;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import com.microsoft.kiota.store.BackedModel;
import com.microsoft.kiota.store.BackingStore;
import com.microsoft.kiota.store.BackingStoreFactorySingleton;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class DeviceActionResult
implements AdditionalDataHolder,
BackedModel,
Parsable {
    @Nonnull
    protected BackingStore backingStore = BackingStoreFactorySingleton.instance.createBackingStore();

    public DeviceActionResult() {
        this.setAdditionalData(new HashMap<String, Object>());
    }

    @Nonnull
    public static DeviceActionResult createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        ParseNode mappingValueNode = parseNode.getChildNode("@odata.type");
        if (mappingValueNode != null) {
            String mappingValue;
            switch (mappingValue = mappingValueNode.getStringValue()) {
                case "#microsoft.graph.deleteUserFromSharedAppleDeviceActionResult": {
                    return new DeleteUserFromSharedAppleDeviceActionResult();
                }
                case "#microsoft.graph.locateDeviceActionResult": {
                    return new LocateDeviceActionResult();
                }
                case "#microsoft.graph.remoteLockActionResult": {
                    return new RemoteLockActionResult();
                }
                case "#microsoft.graph.resetPasscodeActionResult": {
                    return new ResetPasscodeActionResult();
                }
                case "#microsoft.graph.rotateBitLockerKeysDeviceActionResult": {
                    return new RotateBitLockerKeysDeviceActionResult();
                }
                case "#microsoft.graph.windowsDefenderScanActionResult": {
                    return new WindowsDefenderScanActionResult();
                }
            }
        }
        return new DeviceActionResult();
    }

    @Nullable
    public String getActionName() {
        return (String)this.backingStore.get("actionName");
    }

    @Nullable
    public ActionState getActionState() {
        return (ActionState)((Object)this.backingStore.get("actionState"));
    }

    @Nonnull
    public Map<String, Object> getAdditionalData() {
        HashMap<String, Object> value = (HashMap<String, Object>)this.backingStore.get("additionalData");
        if (value == null) {
            value = new HashMap<String, Object>();
            this.setAdditionalData(value);
        }
        return value;
    }

    @Nonnull
    public BackingStore getBackingStore() {
        return this.backingStore;
    }

    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(5);
        deserializerMap.put("actionName", n -> this.setActionName(n.getStringValue()));
        deserializerMap.put("actionState", n -> this.setActionState((ActionState)n.getEnumValue(ActionState::forValue)));
        deserializerMap.put("lastUpdatedDateTime", n -> this.setLastUpdatedDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("@odata.type", n -> this.setOdataType(n.getStringValue()));
        deserializerMap.put("startDateTime", n -> this.setStartDateTime(n.getOffsetDateTimeValue()));
        return deserializerMap;
    }

    @Nullable
    public OffsetDateTime getLastUpdatedDateTime() {
        return (OffsetDateTime)this.backingStore.get("lastUpdatedDateTime");
    }

    @Nullable
    public String getOdataType() {
        return (String)this.backingStore.get("odataType");
    }

    @Nullable
    public OffsetDateTime getStartDateTime() {
        return (OffsetDateTime)this.backingStore.get("startDateTime");
    }

    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        writer.writeStringValue("actionName", this.getActionName());
        writer.writeEnumValue("actionState", (Enum)this.getActionState());
        writer.writeOffsetDateTimeValue("lastUpdatedDateTime", this.getLastUpdatedDateTime());
        writer.writeStringValue("@odata.type", this.getOdataType());
        writer.writeOffsetDateTimeValue("startDateTime", this.getStartDateTime());
        writer.writeAdditionalData(this.getAdditionalData());
    }

    public void setActionName(@Nullable String value) {
        this.backingStore.set("actionName", (Object)value);
    }

    public void setActionState(@Nullable ActionState value) {
        this.backingStore.set("actionState", (Object)value);
    }

    public void setAdditionalData(@Nullable Map<String, Object> value) {
        this.backingStore.set("additionalData", value);
    }

    public void setBackingStore(@Nonnull BackingStore value) {
        Objects.requireNonNull(value);
        this.backingStore = value;
    }

    public void setLastUpdatedDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("lastUpdatedDateTime", (Object)value);
    }

    public void setOdataType(@Nullable String value) {
        this.backingStore.set("odataType", (Object)value);
    }

    public void setStartDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("startDateTime", (Object)value);
    }
}

