/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.DocumentSetVersionItem;
import com.microsoft.graph.models.IdentitySet;
import com.microsoft.graph.models.ListItemVersion;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class DocumentSetVersion
extends ListItemVersion
implements Parsable {
    public DocumentSetVersion() {
        this.setOdataType("#microsoft.graph.documentSetVersion");
    }

    @Nonnull
    public static DocumentSetVersion createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new DocumentSetVersion();
    }

    @Nullable
    public String getComment() {
        return (String)this.backingStore.get("comment");
    }

    @Nullable
    public IdentitySet getCreatedBy() {
        return (IdentitySet)this.backingStore.get("createdBy");
    }

    @Nullable
    public OffsetDateTime getCreatedDateTime() {
        return (OffsetDateTime)this.backingStore.get("createdDateTime");
    }

    @Override
    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("comment", n -> this.setComment(n.getStringValue()));
        deserializerMap.put("createdBy", n -> this.setCreatedBy((IdentitySet)n.getObjectValue(IdentitySet::createFromDiscriminatorValue)));
        deserializerMap.put("createdDateTime", n -> this.setCreatedDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("items", n -> this.setItems(n.getCollectionOfObjectValues(DocumentSetVersionItem::createFromDiscriminatorValue)));
        deserializerMap.put("shouldCaptureMinorVersion", n -> this.setShouldCaptureMinorVersion(n.getBooleanValue()));
        return deserializerMap;
    }

    @Nullable
    public List<DocumentSetVersionItem> getItems() {
        return (List)this.backingStore.get("items");
    }

    @Nullable
    public Boolean getShouldCaptureMinorVersion() {
        return (Boolean)this.backingStore.get("shouldCaptureMinorVersion");
    }

    @Override
    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeStringValue("comment", this.getComment());
        writer.writeObjectValue("createdBy", (Parsable)this.getCreatedBy(), new Parsable[0]);
        writer.writeOffsetDateTimeValue("createdDateTime", this.getCreatedDateTime());
        writer.writeCollectionOfObjectValues("items", this.getItems());
        writer.writeBooleanValue("shouldCaptureMinorVersion", this.getShouldCaptureMinorVersion());
    }

    public void setComment(@Nullable String value) {
        this.backingStore.set("comment", (Object)value);
    }

    public void setCreatedBy(@Nullable IdentitySet value) {
        this.backingStore.set("createdBy", (Object)value);
    }

    public void setCreatedDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("createdDateTime", (Object)value);
    }

    public void setItems(@Nullable List<DocumentSetVersionItem> value) {
        this.backingStore.set("items", value);
    }

    public void setShouldCaptureMinorVersion(@Nullable Boolean value) {
        this.backingStore.set("shouldCaptureMinorVersion", (Object)value);
    }
}

