/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.ChatMessageFromIdentitySet;
import com.microsoft.graph.models.ChatMessageMentionedIdentitySet;
import com.microsoft.graph.models.ChatMessageReactionIdentitySet;
import com.microsoft.graph.models.CommunicationsIdentitySet;
import com.microsoft.graph.models.Identity;
import com.microsoft.graph.models.SharePointIdentitySet;
import com.microsoft.kiota.serialization.AdditionalDataHolder;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import com.microsoft.kiota.store.BackedModel;
import com.microsoft.kiota.store.BackingStore;
import com.microsoft.kiota.store.BackingStoreFactorySingleton;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class IdentitySet
implements AdditionalDataHolder,
BackedModel,
Parsable {
    @Nonnull
    protected BackingStore backingStore = BackingStoreFactorySingleton.instance.createBackingStore();

    public IdentitySet() {
        this.setAdditionalData(new HashMap<String, Object>());
    }

    @Nonnull
    public static IdentitySet createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        ParseNode mappingValueNode = parseNode.getChildNode("@odata.type");
        if (mappingValueNode != null) {
            String mappingValue;
            switch (mappingValue = mappingValueNode.getStringValue()) {
                case "#microsoft.graph.chatMessageFromIdentitySet": {
                    return new ChatMessageFromIdentitySet();
                }
                case "#microsoft.graph.chatMessageMentionedIdentitySet": {
                    return new ChatMessageMentionedIdentitySet();
                }
                case "#microsoft.graph.chatMessageReactionIdentitySet": {
                    return new ChatMessageReactionIdentitySet();
                }
                case "#microsoft.graph.communicationsIdentitySet": {
                    return new CommunicationsIdentitySet();
                }
                case "#microsoft.graph.sharePointIdentitySet": {
                    return new SharePointIdentitySet();
                }
            }
        }
        return new IdentitySet();
    }

    @Nonnull
    public Map<String, Object> getAdditionalData() {
        HashMap<String, Object> value = (HashMap<String, Object>)this.backingStore.get("additionalData");
        if (value == null) {
            value = new HashMap<String, Object>();
            this.setAdditionalData(value);
        }
        return value;
    }

    @Nullable
    public Identity getApplication() {
        return (Identity)this.backingStore.get("application");
    }

    @Nonnull
    public BackingStore getBackingStore() {
        return this.backingStore;
    }

    @Nullable
    public Identity getDevice() {
        return (Identity)this.backingStore.get("device");
    }

    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(4);
        deserializerMap.put("application", n -> this.setApplication((Identity)n.getObjectValue(Identity::createFromDiscriminatorValue)));
        deserializerMap.put("device", n -> this.setDevice((Identity)n.getObjectValue(Identity::createFromDiscriminatorValue)));
        deserializerMap.put("@odata.type", n -> this.setOdataType(n.getStringValue()));
        deserializerMap.put("user", n -> this.setUser((Identity)n.getObjectValue(Identity::createFromDiscriminatorValue)));
        return deserializerMap;
    }

    @Nullable
    public String getOdataType() {
        return (String)this.backingStore.get("odataType");
    }

    @Nullable
    public Identity getUser() {
        return (Identity)this.backingStore.get("user");
    }

    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        writer.writeObjectValue("application", (Parsable)this.getApplication(), new Parsable[0]);
        writer.writeObjectValue("device", (Parsable)this.getDevice(), new Parsable[0]);
        writer.writeStringValue("@odata.type", this.getOdataType());
        writer.writeObjectValue("user", (Parsable)this.getUser(), new Parsable[0]);
        writer.writeAdditionalData(this.getAdditionalData());
    }

    public void setAdditionalData(@Nullable Map<String, Object> value) {
        this.backingStore.set("additionalData", value);
    }

    public void setApplication(@Nullable Identity value) {
        this.backingStore.set("application", (Object)value);
    }

    public void setBackingStore(@Nonnull BackingStore value) {
        Objects.requireNonNull(value);
        this.backingStore = value;
    }

    public void setDevice(@Nullable Identity value) {
        this.backingStore.set("device", (Object)value);
    }

    public void setOdataType(@Nullable String value) {
        this.backingStore.set("odataType", (Object)value);
    }

    public void setUser(@Nullable Identity value) {
        this.backingStore.set("user", (Object)value);
    }
}

