/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.MacOSLobChildApp;
import com.microsoft.graph.models.MacOSMinimumOperatingSystem;
import com.microsoft.graph.models.MobileLobApp;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class MacOSLobApp
extends MobileLobApp
implements Parsable {
    public MacOSLobApp() {
        this.setOdataType("#microsoft.graph.macOSLobApp");
    }

    @Nonnull
    public static MacOSLobApp createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new MacOSLobApp();
    }

    @Nullable
    public String getBuildNumber() {
        return (String)this.backingStore.get("buildNumber");
    }

    @Nullable
    public String getBundleId() {
        return (String)this.backingStore.get("bundleId");
    }

    @Nullable
    public List<MacOSLobChildApp> getChildApps() {
        return (List)this.backingStore.get("childApps");
    }

    @Override
    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("buildNumber", n -> this.setBuildNumber(n.getStringValue()));
        deserializerMap.put("bundleId", n -> this.setBundleId(n.getStringValue()));
        deserializerMap.put("childApps", n -> this.setChildApps(n.getCollectionOfObjectValues(MacOSLobChildApp::createFromDiscriminatorValue)));
        deserializerMap.put("ignoreVersionDetection", n -> this.setIgnoreVersionDetection(n.getBooleanValue()));
        deserializerMap.put("installAsManaged", n -> this.setInstallAsManaged(n.getBooleanValue()));
        deserializerMap.put("md5Hash", n -> this.setMd5Hash(n.getCollectionOfPrimitiveValues(String.class)));
        deserializerMap.put("md5HashChunkSize", n -> this.setMd5HashChunkSize(n.getIntegerValue()));
        deserializerMap.put("minimumSupportedOperatingSystem", n -> this.setMinimumSupportedOperatingSystem((MacOSMinimumOperatingSystem)n.getObjectValue(MacOSMinimumOperatingSystem::createFromDiscriminatorValue)));
        deserializerMap.put("versionNumber", n -> this.setVersionNumber(n.getStringValue()));
        return deserializerMap;
    }

    @Nullable
    public Boolean getIgnoreVersionDetection() {
        return (Boolean)this.backingStore.get("ignoreVersionDetection");
    }

    @Nullable
    public Boolean getInstallAsManaged() {
        return (Boolean)this.backingStore.get("installAsManaged");
    }

    @Nullable
    public List<String> getMd5Hash() {
        return (List)this.backingStore.get("md5Hash");
    }

    @Nullable
    public Integer getMd5HashChunkSize() {
        return (Integer)this.backingStore.get("md5HashChunkSize");
    }

    @Nullable
    public MacOSMinimumOperatingSystem getMinimumSupportedOperatingSystem() {
        return (MacOSMinimumOperatingSystem)this.backingStore.get("minimumSupportedOperatingSystem");
    }

    @Nullable
    public String getVersionNumber() {
        return (String)this.backingStore.get("versionNumber");
    }

    @Override
    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeStringValue("buildNumber", this.getBuildNumber());
        writer.writeStringValue("bundleId", this.getBundleId());
        writer.writeCollectionOfObjectValues("childApps", this.getChildApps());
        writer.writeBooleanValue("ignoreVersionDetection", this.getIgnoreVersionDetection());
        writer.writeBooleanValue("installAsManaged", this.getInstallAsManaged());
        writer.writeCollectionOfPrimitiveValues("md5Hash", this.getMd5Hash());
        writer.writeIntegerValue("md5HashChunkSize", this.getMd5HashChunkSize());
        writer.writeObjectValue("minimumSupportedOperatingSystem", (Parsable)this.getMinimumSupportedOperatingSystem(), new Parsable[0]);
        writer.writeStringValue("versionNumber", this.getVersionNumber());
    }

    public void setBuildNumber(@Nullable String value) {
        this.backingStore.set("buildNumber", (Object)value);
    }

    public void setBundleId(@Nullable String value) {
        this.backingStore.set("bundleId", (Object)value);
    }

    public void setChildApps(@Nullable List<MacOSLobChildApp> value) {
        this.backingStore.set("childApps", value);
    }

    public void setIgnoreVersionDetection(@Nullable Boolean value) {
        this.backingStore.set("ignoreVersionDetection", (Object)value);
    }

    public void setInstallAsManaged(@Nullable Boolean value) {
        this.backingStore.set("installAsManaged", (Object)value);
    }

    public void setMd5Hash(@Nullable List<String> value) {
        this.backingStore.set("md5Hash", value);
    }

    public void setMd5HashChunkSize(@Nullable Integer value) {
        this.backingStore.set("md5HashChunkSize", (Object)value);
    }

    public void setMinimumSupportedOperatingSystem(@Nullable MacOSMinimumOperatingSystem value) {
        this.backingStore.set("minimumSupportedOperatingSystem", (Object)value);
    }

    public void setVersionNumber(@Nullable String value) {
        this.backingStore.set("versionNumber", (Object)value);
    }
}

