/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.MicrosoftTrainingAssignmentMapping;
import com.microsoft.graph.models.TrainingCompletionDuration;
import com.microsoft.graph.models.TrainingSetting;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class MicrosoftCustomTrainingSetting
extends TrainingSetting
implements Parsable {
    public MicrosoftCustomTrainingSetting() {
        this.setOdataType("#microsoft.graph.microsoftCustomTrainingSetting");
    }

    @Nonnull
    public static MicrosoftCustomTrainingSetting createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new MicrosoftCustomTrainingSetting();
    }

    @Nullable
    public OffsetDateTime getCompletionDateTime() {
        return (OffsetDateTime)this.backingStore.get("completionDateTime");
    }

    @Override
    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("completionDateTime", n -> this.setCompletionDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("trainingAssignmentMappings", n -> this.setTrainingAssignmentMappings(n.getCollectionOfObjectValues(MicrosoftTrainingAssignmentMapping::createFromDiscriminatorValue)));
        deserializerMap.put("trainingCompletionDuration", n -> this.setTrainingCompletionDuration((TrainingCompletionDuration)n.getEnumValue(TrainingCompletionDuration::forValue)));
        return deserializerMap;
    }

    @Nullable
    public List<MicrosoftTrainingAssignmentMapping> getTrainingAssignmentMappings() {
        return (List)this.backingStore.get("trainingAssignmentMappings");
    }

    @Nullable
    public TrainingCompletionDuration getTrainingCompletionDuration() {
        return (TrainingCompletionDuration)((Object)this.backingStore.get("trainingCompletionDuration"));
    }

    @Override
    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeOffsetDateTimeValue("completionDateTime", this.getCompletionDateTime());
        writer.writeCollectionOfObjectValues("trainingAssignmentMappings", this.getTrainingAssignmentMappings());
        writer.writeEnumValue("trainingCompletionDuration", (Enum)this.getTrainingCompletionDuration());
    }

    public void setCompletionDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("completionDateTime", (Object)value);
    }

    public void setTrainingAssignmentMappings(@Nullable List<MicrosoftTrainingAssignmentMapping> value) {
        this.backingStore.set("trainingAssignmentMappings", value);
    }

    public void setTrainingCompletionDuration(@Nullable TrainingCompletionDuration value) {
        this.backingStore.set("trainingCompletionDuration", (Object)value);
    }
}

