/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.AndroidLobApp;
import com.microsoft.graph.models.AndroidStoreApp;
import com.microsoft.graph.models.Entity;
import com.microsoft.graph.models.IosLobApp;
import com.microsoft.graph.models.IosStoreApp;
import com.microsoft.graph.models.IosVppApp;
import com.microsoft.graph.models.IosiPadOSWebClip;
import com.microsoft.graph.models.MacOSDmgApp;
import com.microsoft.graph.models.MacOSLobApp;
import com.microsoft.graph.models.MacOSMicrosoftDefenderApp;
import com.microsoft.graph.models.MacOSMicrosoftEdgeApp;
import com.microsoft.graph.models.MacOSOfficeSuiteApp;
import com.microsoft.graph.models.ManagedAndroidLobApp;
import com.microsoft.graph.models.ManagedAndroidStoreApp;
import com.microsoft.graph.models.ManagedApp;
import com.microsoft.graph.models.ManagedIOSLobApp;
import com.microsoft.graph.models.ManagedIOSStoreApp;
import com.microsoft.graph.models.ManagedMobileLobApp;
import com.microsoft.graph.models.MicrosoftStoreForBusinessApp;
import com.microsoft.graph.models.MimeContent;
import com.microsoft.graph.models.MobileAppAssignment;
import com.microsoft.graph.models.MobileAppCategory;
import com.microsoft.graph.models.MobileAppPublishingState;
import com.microsoft.graph.models.MobileLobApp;
import com.microsoft.graph.models.WebApp;
import com.microsoft.graph.models.Win32LobApp;
import com.microsoft.graph.models.WindowsAppX;
import com.microsoft.graph.models.WindowsMicrosoftEdgeApp;
import com.microsoft.graph.models.WindowsMobileMSI;
import com.microsoft.graph.models.WindowsUniversalAppX;
import com.microsoft.graph.models.WindowsWebApp;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class MobileApp
extends Entity
implements Parsable {
    @Nonnull
    public static MobileApp createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        ParseNode mappingValueNode = parseNode.getChildNode("@odata.type");
        if (mappingValueNode != null) {
            String mappingValue;
            switch (mappingValue = mappingValueNode.getStringValue()) {
                case "#microsoft.graph.androidLobApp": {
                    return new AndroidLobApp();
                }
                case "#microsoft.graph.androidStoreApp": {
                    return new AndroidStoreApp();
                }
                case "#microsoft.graph.iosiPadOSWebClip": {
                    return new IosiPadOSWebClip();
                }
                case "#microsoft.graph.iosLobApp": {
                    return new IosLobApp();
                }
                case "#microsoft.graph.iosStoreApp": {
                    return new IosStoreApp();
                }
                case "#microsoft.graph.iosVppApp": {
                    return new IosVppApp();
                }
                case "#microsoft.graph.macOSDmgApp": {
                    return new MacOSDmgApp();
                }
                case "#microsoft.graph.macOSLobApp": {
                    return new MacOSLobApp();
                }
                case "#microsoft.graph.macOSMicrosoftDefenderApp": {
                    return new MacOSMicrosoftDefenderApp();
                }
                case "#microsoft.graph.macOSMicrosoftEdgeApp": {
                    return new MacOSMicrosoftEdgeApp();
                }
                case "#microsoft.graph.macOSOfficeSuiteApp": {
                    return new MacOSOfficeSuiteApp();
                }
                case "#microsoft.graph.managedAndroidLobApp": {
                    return new ManagedAndroidLobApp();
                }
                case "#microsoft.graph.managedAndroidStoreApp": {
                    return new ManagedAndroidStoreApp();
                }
                case "#microsoft.graph.managedApp": {
                    return new ManagedApp();
                }
                case "#microsoft.graph.managedIOSLobApp": {
                    return new ManagedIOSLobApp();
                }
                case "#microsoft.graph.managedIOSStoreApp": {
                    return new ManagedIOSStoreApp();
                }
                case "#microsoft.graph.managedMobileLobApp": {
                    return new ManagedMobileLobApp();
                }
                case "#microsoft.graph.microsoftStoreForBusinessApp": {
                    return new MicrosoftStoreForBusinessApp();
                }
                case "#microsoft.graph.mobileLobApp": {
                    return new MobileLobApp();
                }
                case "#microsoft.graph.webApp": {
                    return new WebApp();
                }
                case "#microsoft.graph.win32LobApp": {
                    return new Win32LobApp();
                }
                case "#microsoft.graph.windowsAppX": {
                    return new WindowsAppX();
                }
                case "#microsoft.graph.windowsMicrosoftEdgeApp": {
                    return new WindowsMicrosoftEdgeApp();
                }
                case "#microsoft.graph.windowsMobileMSI": {
                    return new WindowsMobileMSI();
                }
                case "#microsoft.graph.windowsUniversalAppX": {
                    return new WindowsUniversalAppX();
                }
                case "#microsoft.graph.windowsWebApp": {
                    return new WindowsWebApp();
                }
            }
        }
        return new MobileApp();
    }

    @Nullable
    public List<MobileAppAssignment> getAssignments() {
        return (List)this.backingStore.get("assignments");
    }

    @Nullable
    public List<MobileAppCategory> getCategories() {
        return (List)this.backingStore.get("categories");
    }

    @Nullable
    public OffsetDateTime getCreatedDateTime() {
        return (OffsetDateTime)this.backingStore.get("createdDateTime");
    }

    @Nullable
    public String getDescription() {
        return (String)this.backingStore.get("description");
    }

    @Nullable
    public String getDeveloper() {
        return (String)this.backingStore.get("developer");
    }

    @Nullable
    public String getDisplayName() {
        return (String)this.backingStore.get("displayName");
    }

    @Override
    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("assignments", n -> this.setAssignments(n.getCollectionOfObjectValues(MobileAppAssignment::createFromDiscriminatorValue)));
        deserializerMap.put("categories", n -> this.setCategories(n.getCollectionOfObjectValues(MobileAppCategory::createFromDiscriminatorValue)));
        deserializerMap.put("createdDateTime", n -> this.setCreatedDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("description", n -> this.setDescription(n.getStringValue()));
        deserializerMap.put("developer", n -> this.setDeveloper(n.getStringValue()));
        deserializerMap.put("displayName", n -> this.setDisplayName(n.getStringValue()));
        deserializerMap.put("informationUrl", n -> this.setInformationUrl(n.getStringValue()));
        deserializerMap.put("isFeatured", n -> this.setIsFeatured(n.getBooleanValue()));
        deserializerMap.put("largeIcon", n -> this.setLargeIcon((MimeContent)n.getObjectValue(MimeContent::createFromDiscriminatorValue)));
        deserializerMap.put("lastModifiedDateTime", n -> this.setLastModifiedDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("notes", n -> this.setNotes(n.getStringValue()));
        deserializerMap.put("owner", n -> this.setOwner(n.getStringValue()));
        deserializerMap.put("privacyInformationUrl", n -> this.setPrivacyInformationUrl(n.getStringValue()));
        deserializerMap.put("publisher", n -> this.setPublisher(n.getStringValue()));
        deserializerMap.put("publishingState", n -> this.setPublishingState((MobileAppPublishingState)n.getEnumValue(MobileAppPublishingState::forValue)));
        return deserializerMap;
    }

    @Nullable
    public String getInformationUrl() {
        return (String)this.backingStore.get("informationUrl");
    }

    @Nullable
    public Boolean getIsFeatured() {
        return (Boolean)this.backingStore.get("isFeatured");
    }

    @Nullable
    public MimeContent getLargeIcon() {
        return (MimeContent)this.backingStore.get("largeIcon");
    }

    @Nullable
    public OffsetDateTime getLastModifiedDateTime() {
        return (OffsetDateTime)this.backingStore.get("lastModifiedDateTime");
    }

    @Nullable
    public String getNotes() {
        return (String)this.backingStore.get("notes");
    }

    @Nullable
    public String getOwner() {
        return (String)this.backingStore.get("owner");
    }

    @Nullable
    public String getPrivacyInformationUrl() {
        return (String)this.backingStore.get("privacyInformationUrl");
    }

    @Nullable
    public String getPublisher() {
        return (String)this.backingStore.get("publisher");
    }

    @Nullable
    public MobileAppPublishingState getPublishingState() {
        return (MobileAppPublishingState)((Object)this.backingStore.get("publishingState"));
    }

    @Override
    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeCollectionOfObjectValues("assignments", this.getAssignments());
        writer.writeCollectionOfObjectValues("categories", this.getCategories());
        writer.writeStringValue("description", this.getDescription());
        writer.writeStringValue("developer", this.getDeveloper());
        writer.writeStringValue("displayName", this.getDisplayName());
        writer.writeStringValue("informationUrl", this.getInformationUrl());
        writer.writeBooleanValue("isFeatured", this.getIsFeatured());
        writer.writeObjectValue("largeIcon", (Parsable)this.getLargeIcon(), new Parsable[0]);
        writer.writeStringValue("notes", this.getNotes());
        writer.writeStringValue("owner", this.getOwner());
        writer.writeStringValue("privacyInformationUrl", this.getPrivacyInformationUrl());
        writer.writeStringValue("publisher", this.getPublisher());
        writer.writeEnumValue("publishingState", (Enum)this.getPublishingState());
    }

    public void setAssignments(@Nullable List<MobileAppAssignment> value) {
        this.backingStore.set("assignments", value);
    }

    public void setCategories(@Nullable List<MobileAppCategory> value) {
        this.backingStore.set("categories", value);
    }

    public void setCreatedDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("createdDateTime", (Object)value);
    }

    public void setDescription(@Nullable String value) {
        this.backingStore.set("description", (Object)value);
    }

    public void setDeveloper(@Nullable String value) {
        this.backingStore.set("developer", (Object)value);
    }

    public void setDisplayName(@Nullable String value) {
        this.backingStore.set("displayName", (Object)value);
    }

    public void setInformationUrl(@Nullable String value) {
        this.backingStore.set("informationUrl", (Object)value);
    }

    public void setIsFeatured(@Nullable Boolean value) {
        this.backingStore.set("isFeatured", (Object)value);
    }

    public void setLargeIcon(@Nullable MimeContent value) {
        this.backingStore.set("largeIcon", (Object)value);
    }

    public void setLastModifiedDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("lastModifiedDateTime", (Object)value);
    }

    public void setNotes(@Nullable String value) {
        this.backingStore.set("notes", (Object)value);
    }

    public void setOwner(@Nullable String value) {
        this.backingStore.set("owner", (Object)value);
    }

    public void setPrivacyInformationUrl(@Nullable String value) {
        this.backingStore.set("privacyInformationUrl", (Object)value);
    }

    public void setPublisher(@Nullable String value) {
        this.backingStore.set("publisher", (Object)value);
    }

    public void setPublishingState(@Nullable MobileAppPublishingState value) {
        this.backingStore.set("publishingState", (Object)value);
    }
}

