/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.ContentCustomization;
import com.microsoft.graph.models.Entity;
import com.microsoft.graph.models.LoginPageLayoutConfiguration;
import com.microsoft.graph.models.LoginPageTextVisibilitySettings;
import com.microsoft.graph.models.OrganizationalBranding;
import com.microsoft.graph.models.OrganizationalBrandingLocalization;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class OrganizationalBrandingProperties
extends Entity
implements Parsable {
    @Nonnull
    public static OrganizationalBrandingProperties createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        ParseNode mappingValueNode = parseNode.getChildNode("@odata.type");
        if (mappingValueNode != null) {
            String mappingValue;
            switch (mappingValue = mappingValueNode.getStringValue()) {
                case "#microsoft.graph.organizationalBranding": {
                    return new OrganizationalBranding();
                }
                case "#microsoft.graph.organizationalBrandingLocalization": {
                    return new OrganizationalBrandingLocalization();
                }
            }
        }
        return new OrganizationalBrandingProperties();
    }

    @Nullable
    public String getBackgroundColor() {
        return (String)this.backingStore.get("backgroundColor");
    }

    @Nullable
    public byte[] getBackgroundImage() {
        return (byte[])this.backingStore.get("backgroundImage");
    }

    @Nullable
    public String getBackgroundImageRelativeUrl() {
        return (String)this.backingStore.get("backgroundImageRelativeUrl");
    }

    @Nullable
    public byte[] getBannerLogo() {
        return (byte[])this.backingStore.get("bannerLogo");
    }

    @Nullable
    public String getBannerLogoRelativeUrl() {
        return (String)this.backingStore.get("bannerLogoRelativeUrl");
    }

    @Nullable
    public List<String> getCdnList() {
        return (List)this.backingStore.get("cdnList");
    }

    @Nullable
    public ContentCustomization getContentCustomization() {
        return (ContentCustomization)this.backingStore.get("contentCustomization");
    }

    @Nullable
    public String getCustomAccountResetCredentialsUrl() {
        return (String)this.backingStore.get("customAccountResetCredentialsUrl");
    }

    @Nullable
    public String getCustomCannotAccessYourAccountText() {
        return (String)this.backingStore.get("customCannotAccessYourAccountText");
    }

    @Nullable
    public String getCustomCannotAccessYourAccountUrl() {
        return (String)this.backingStore.get("customCannotAccessYourAccountUrl");
    }

    @Nullable
    public byte[] getCustomCSS() {
        return (byte[])this.backingStore.get("customCSS");
    }

    @Nullable
    public String getCustomCSSRelativeUrl() {
        return (String)this.backingStore.get("customCSSRelativeUrl");
    }

    @Nullable
    public String getCustomForgotMyPasswordText() {
        return (String)this.backingStore.get("customForgotMyPasswordText");
    }

    @Nullable
    public String getCustomPrivacyAndCookiesText() {
        return (String)this.backingStore.get("customPrivacyAndCookiesText");
    }

    @Nullable
    public String getCustomPrivacyAndCookiesUrl() {
        return (String)this.backingStore.get("customPrivacyAndCookiesUrl");
    }

    @Nullable
    public String getCustomResetItNowText() {
        return (String)this.backingStore.get("customResetItNowText");
    }

    @Nullable
    public String getCustomTermsOfUseText() {
        return (String)this.backingStore.get("customTermsOfUseText");
    }

    @Nullable
    public String getCustomTermsOfUseUrl() {
        return (String)this.backingStore.get("customTermsOfUseUrl");
    }

    @Nullable
    public byte[] getFavicon() {
        return (byte[])this.backingStore.get("favicon");
    }

    @Nullable
    public String getFaviconRelativeUrl() {
        return (String)this.backingStore.get("faviconRelativeUrl");
    }

    @Override
    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("backgroundColor", n -> this.setBackgroundColor(n.getStringValue()));
        deserializerMap.put("backgroundImage", n -> this.setBackgroundImage(n.getByteArrayValue()));
        deserializerMap.put("backgroundImageRelativeUrl", n -> this.setBackgroundImageRelativeUrl(n.getStringValue()));
        deserializerMap.put("bannerLogo", n -> this.setBannerLogo(n.getByteArrayValue()));
        deserializerMap.put("bannerLogoRelativeUrl", n -> this.setBannerLogoRelativeUrl(n.getStringValue()));
        deserializerMap.put("cdnList", n -> this.setCdnList(n.getCollectionOfPrimitiveValues(String.class)));
        deserializerMap.put("contentCustomization", n -> this.setContentCustomization((ContentCustomization)n.getObjectValue(ContentCustomization::createFromDiscriminatorValue)));
        deserializerMap.put("customAccountResetCredentialsUrl", n -> this.setCustomAccountResetCredentialsUrl(n.getStringValue()));
        deserializerMap.put("customCannotAccessYourAccountText", n -> this.setCustomCannotAccessYourAccountText(n.getStringValue()));
        deserializerMap.put("customCannotAccessYourAccountUrl", n -> this.setCustomCannotAccessYourAccountUrl(n.getStringValue()));
        deserializerMap.put("customCSS", n -> this.setCustomCSS(n.getByteArrayValue()));
        deserializerMap.put("customCSSRelativeUrl", n -> this.setCustomCSSRelativeUrl(n.getStringValue()));
        deserializerMap.put("customForgotMyPasswordText", n -> this.setCustomForgotMyPasswordText(n.getStringValue()));
        deserializerMap.put("customPrivacyAndCookiesText", n -> this.setCustomPrivacyAndCookiesText(n.getStringValue()));
        deserializerMap.put("customPrivacyAndCookiesUrl", n -> this.setCustomPrivacyAndCookiesUrl(n.getStringValue()));
        deserializerMap.put("customResetItNowText", n -> this.setCustomResetItNowText(n.getStringValue()));
        deserializerMap.put("customTermsOfUseText", n -> this.setCustomTermsOfUseText(n.getStringValue()));
        deserializerMap.put("customTermsOfUseUrl", n -> this.setCustomTermsOfUseUrl(n.getStringValue()));
        deserializerMap.put("favicon", n -> this.setFavicon(n.getByteArrayValue()));
        deserializerMap.put("faviconRelativeUrl", n -> this.setFaviconRelativeUrl(n.getStringValue()));
        deserializerMap.put("headerBackgroundColor", n -> this.setHeaderBackgroundColor(n.getStringValue()));
        deserializerMap.put("headerLogo", n -> this.setHeaderLogo(n.getByteArrayValue()));
        deserializerMap.put("headerLogoRelativeUrl", n -> this.setHeaderLogoRelativeUrl(n.getStringValue()));
        deserializerMap.put("loginPageLayoutConfiguration", n -> this.setLoginPageLayoutConfiguration((LoginPageLayoutConfiguration)n.getObjectValue(LoginPageLayoutConfiguration::createFromDiscriminatorValue)));
        deserializerMap.put("loginPageTextVisibilitySettings", n -> this.setLoginPageTextVisibilitySettings((LoginPageTextVisibilitySettings)n.getObjectValue(LoginPageTextVisibilitySettings::createFromDiscriminatorValue)));
        deserializerMap.put("signInPageText", n -> this.setSignInPageText(n.getStringValue()));
        deserializerMap.put("squareLogo", n -> this.setSquareLogo(n.getByteArrayValue()));
        deserializerMap.put("squareLogoDark", n -> this.setSquareLogoDark(n.getByteArrayValue()));
        deserializerMap.put("squareLogoDarkRelativeUrl", n -> this.setSquareLogoDarkRelativeUrl(n.getStringValue()));
        deserializerMap.put("squareLogoRelativeUrl", n -> this.setSquareLogoRelativeUrl(n.getStringValue()));
        deserializerMap.put("usernameHintText", n -> this.setUsernameHintText(n.getStringValue()));
        return deserializerMap;
    }

    @Nullable
    public String getHeaderBackgroundColor() {
        return (String)this.backingStore.get("headerBackgroundColor");
    }

    @Nullable
    public byte[] getHeaderLogo() {
        return (byte[])this.backingStore.get("headerLogo");
    }

    @Nullable
    public String getHeaderLogoRelativeUrl() {
        return (String)this.backingStore.get("headerLogoRelativeUrl");
    }

    @Nullable
    public LoginPageLayoutConfiguration getLoginPageLayoutConfiguration() {
        return (LoginPageLayoutConfiguration)this.backingStore.get("loginPageLayoutConfiguration");
    }

    @Nullable
    public LoginPageTextVisibilitySettings getLoginPageTextVisibilitySettings() {
        return (LoginPageTextVisibilitySettings)this.backingStore.get("loginPageTextVisibilitySettings");
    }

    @Nullable
    public String getSignInPageText() {
        return (String)this.backingStore.get("signInPageText");
    }

    @Nullable
    public byte[] getSquareLogo() {
        return (byte[])this.backingStore.get("squareLogo");
    }

    @Nullable
    public byte[] getSquareLogoDark() {
        return (byte[])this.backingStore.get("squareLogoDark");
    }

    @Nullable
    public String getSquareLogoDarkRelativeUrl() {
        return (String)this.backingStore.get("squareLogoDarkRelativeUrl");
    }

    @Nullable
    public String getSquareLogoRelativeUrl() {
        return (String)this.backingStore.get("squareLogoRelativeUrl");
    }

    @Nullable
    public String getUsernameHintText() {
        return (String)this.backingStore.get("usernameHintText");
    }

    @Override
    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeStringValue("backgroundColor", this.getBackgroundColor());
        writer.writeByteArrayValue("backgroundImage", this.getBackgroundImage());
        writer.writeStringValue("backgroundImageRelativeUrl", this.getBackgroundImageRelativeUrl());
        writer.writeByteArrayValue("bannerLogo", this.getBannerLogo());
        writer.writeStringValue("bannerLogoRelativeUrl", this.getBannerLogoRelativeUrl());
        writer.writeCollectionOfPrimitiveValues("cdnList", this.getCdnList());
        writer.writeObjectValue("contentCustomization", (Parsable)this.getContentCustomization(), new Parsable[0]);
        writer.writeStringValue("customAccountResetCredentialsUrl", this.getCustomAccountResetCredentialsUrl());
        writer.writeStringValue("customCannotAccessYourAccountText", this.getCustomCannotAccessYourAccountText());
        writer.writeStringValue("customCannotAccessYourAccountUrl", this.getCustomCannotAccessYourAccountUrl());
        writer.writeByteArrayValue("customCSS", this.getCustomCSS());
        writer.writeStringValue("customCSSRelativeUrl", this.getCustomCSSRelativeUrl());
        writer.writeStringValue("customForgotMyPasswordText", this.getCustomForgotMyPasswordText());
        writer.writeStringValue("customPrivacyAndCookiesText", this.getCustomPrivacyAndCookiesText());
        writer.writeStringValue("customPrivacyAndCookiesUrl", this.getCustomPrivacyAndCookiesUrl());
        writer.writeStringValue("customResetItNowText", this.getCustomResetItNowText());
        writer.writeStringValue("customTermsOfUseText", this.getCustomTermsOfUseText());
        writer.writeStringValue("customTermsOfUseUrl", this.getCustomTermsOfUseUrl());
        writer.writeByteArrayValue("favicon", this.getFavicon());
        writer.writeStringValue("faviconRelativeUrl", this.getFaviconRelativeUrl());
        writer.writeStringValue("headerBackgroundColor", this.getHeaderBackgroundColor());
        writer.writeByteArrayValue("headerLogo", this.getHeaderLogo());
        writer.writeStringValue("headerLogoRelativeUrl", this.getHeaderLogoRelativeUrl());
        writer.writeObjectValue("loginPageLayoutConfiguration", (Parsable)this.getLoginPageLayoutConfiguration(), new Parsable[0]);
        writer.writeObjectValue("loginPageTextVisibilitySettings", (Parsable)this.getLoginPageTextVisibilitySettings(), new Parsable[0]);
        writer.writeStringValue("signInPageText", this.getSignInPageText());
        writer.writeByteArrayValue("squareLogo", this.getSquareLogo());
        writer.writeByteArrayValue("squareLogoDark", this.getSquareLogoDark());
        writer.writeStringValue("squareLogoDarkRelativeUrl", this.getSquareLogoDarkRelativeUrl());
        writer.writeStringValue("squareLogoRelativeUrl", this.getSquareLogoRelativeUrl());
        writer.writeStringValue("usernameHintText", this.getUsernameHintText());
    }

    public void setBackgroundColor(@Nullable String value) {
        this.backingStore.set("backgroundColor", (Object)value);
    }

    public void setBackgroundImage(@Nullable byte[] value) {
        this.backingStore.set("backgroundImage", (Object)value);
    }

    public void setBackgroundImageRelativeUrl(@Nullable String value) {
        this.backingStore.set("backgroundImageRelativeUrl", (Object)value);
    }

    public void setBannerLogo(@Nullable byte[] value) {
        this.backingStore.set("bannerLogo", (Object)value);
    }

    public void setBannerLogoRelativeUrl(@Nullable String value) {
        this.backingStore.set("bannerLogoRelativeUrl", (Object)value);
    }

    public void setCdnList(@Nullable List<String> value) {
        this.backingStore.set("cdnList", value);
    }

    public void setContentCustomization(@Nullable ContentCustomization value) {
        this.backingStore.set("contentCustomization", (Object)value);
    }

    public void setCustomAccountResetCredentialsUrl(@Nullable String value) {
        this.backingStore.set("customAccountResetCredentialsUrl", (Object)value);
    }

    public void setCustomCannotAccessYourAccountText(@Nullable String value) {
        this.backingStore.set("customCannotAccessYourAccountText", (Object)value);
    }

    public void setCustomCannotAccessYourAccountUrl(@Nullable String value) {
        this.backingStore.set("customCannotAccessYourAccountUrl", (Object)value);
    }

    public void setCustomCSS(@Nullable byte[] value) {
        this.backingStore.set("customCSS", (Object)value);
    }

    public void setCustomCSSRelativeUrl(@Nullable String value) {
        this.backingStore.set("customCSSRelativeUrl", (Object)value);
    }

    public void setCustomForgotMyPasswordText(@Nullable String value) {
        this.backingStore.set("customForgotMyPasswordText", (Object)value);
    }

    public void setCustomPrivacyAndCookiesText(@Nullable String value) {
        this.backingStore.set("customPrivacyAndCookiesText", (Object)value);
    }

    public void setCustomPrivacyAndCookiesUrl(@Nullable String value) {
        this.backingStore.set("customPrivacyAndCookiesUrl", (Object)value);
    }

    public void setCustomResetItNowText(@Nullable String value) {
        this.backingStore.set("customResetItNowText", (Object)value);
    }

    public void setCustomTermsOfUseText(@Nullable String value) {
        this.backingStore.set("customTermsOfUseText", (Object)value);
    }

    public void setCustomTermsOfUseUrl(@Nullable String value) {
        this.backingStore.set("customTermsOfUseUrl", (Object)value);
    }

    public void setFavicon(@Nullable byte[] value) {
        this.backingStore.set("favicon", (Object)value);
    }

    public void setFaviconRelativeUrl(@Nullable String value) {
        this.backingStore.set("faviconRelativeUrl", (Object)value);
    }

    public void setHeaderBackgroundColor(@Nullable String value) {
        this.backingStore.set("headerBackgroundColor", (Object)value);
    }

    public void setHeaderLogo(@Nullable byte[] value) {
        this.backingStore.set("headerLogo", (Object)value);
    }

    public void setHeaderLogoRelativeUrl(@Nullable String value) {
        this.backingStore.set("headerLogoRelativeUrl", (Object)value);
    }

    public void setLoginPageLayoutConfiguration(@Nullable LoginPageLayoutConfiguration value) {
        this.backingStore.set("loginPageLayoutConfiguration", (Object)value);
    }

    public void setLoginPageTextVisibilitySettings(@Nullable LoginPageTextVisibilitySettings value) {
        this.backingStore.set("loginPageTextVisibilitySettings", (Object)value);
    }

    public void setSignInPageText(@Nullable String value) {
        this.backingStore.set("signInPageText", (Object)value);
    }

    public void setSquareLogo(@Nullable byte[] value) {
        this.backingStore.set("squareLogo", (Object)value);
    }

    public void setSquareLogoDark(@Nullable byte[] value) {
        this.backingStore.set("squareLogoDark", (Object)value);
    }

    public void setSquareLogoDarkRelativeUrl(@Nullable String value) {
        this.backingStore.set("squareLogoDarkRelativeUrl", (Object)value);
    }

    public void setSquareLogoRelativeUrl(@Nullable String value) {
        this.backingStore.set("squareLogoRelativeUrl", (Object)value);
    }

    public void setUsernameHintText(@Nullable String value) {
        this.backingStore.set("usernameHintText", (Object)value);
    }
}

