/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.OpenShiftItem;
import com.microsoft.graph.models.ScheduleEntityTheme;
import com.microsoft.graph.models.ShiftItem;
import com.microsoft.graph.models.TimeOffItem;
import com.microsoft.kiota.serialization.AdditionalDataHolder;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import com.microsoft.kiota.store.BackedModel;
import com.microsoft.kiota.store.BackingStore;
import com.microsoft.kiota.store.BackingStoreFactorySingleton;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class ScheduleEntity
implements AdditionalDataHolder,
BackedModel,
Parsable {
    @Nonnull
    protected BackingStore backingStore = BackingStoreFactorySingleton.instance.createBackingStore();

    public ScheduleEntity() {
        this.setAdditionalData(new HashMap<String, Object>());
    }

    @Nonnull
    public static ScheduleEntity createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        ParseNode mappingValueNode = parseNode.getChildNode("@odata.type");
        if (mappingValueNode != null) {
            String mappingValue;
            switch (mappingValue = mappingValueNode.getStringValue()) {
                case "#microsoft.graph.openShiftItem": {
                    return new OpenShiftItem();
                }
                case "#microsoft.graph.shiftItem": {
                    return new ShiftItem();
                }
                case "#microsoft.graph.timeOffItem": {
                    return new TimeOffItem();
                }
            }
        }
        return new ScheduleEntity();
    }

    @Nonnull
    public Map<String, Object> getAdditionalData() {
        HashMap<String, Object> value = (HashMap<String, Object>)this.backingStore.get("additionalData");
        if (value == null) {
            value = new HashMap<String, Object>();
            this.setAdditionalData(value);
        }
        return value;
    }

    @Nonnull
    public BackingStore getBackingStore() {
        return this.backingStore;
    }

    @Nullable
    public OffsetDateTime getEndDateTime() {
        return (OffsetDateTime)this.backingStore.get("endDateTime");
    }

    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(4);
        deserializerMap.put("endDateTime", n -> this.setEndDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("@odata.type", n -> this.setOdataType(n.getStringValue()));
        deserializerMap.put("startDateTime", n -> this.setStartDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("theme", n -> this.setTheme((ScheduleEntityTheme)n.getEnumValue(ScheduleEntityTheme::forValue)));
        return deserializerMap;
    }

    @Nullable
    public String getOdataType() {
        return (String)this.backingStore.get("odataType");
    }

    @Nullable
    public OffsetDateTime getStartDateTime() {
        return (OffsetDateTime)this.backingStore.get("startDateTime");
    }

    @Nullable
    public ScheduleEntityTheme getTheme() {
        return (ScheduleEntityTheme)((Object)this.backingStore.get("theme"));
    }

    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        writer.writeOffsetDateTimeValue("endDateTime", this.getEndDateTime());
        writer.writeStringValue("@odata.type", this.getOdataType());
        writer.writeOffsetDateTimeValue("startDateTime", this.getStartDateTime());
        writer.writeEnumValue("theme", (Enum)this.getTheme());
        writer.writeAdditionalData(this.getAdditionalData());
    }

    public void setAdditionalData(@Nullable Map<String, Object> value) {
        this.backingStore.set("additionalData", value);
    }

    public void setBackingStore(@Nonnull BackingStore value) {
        Objects.requireNonNull(value);
        this.backingStore = value;
    }

    public void setEndDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("endDateTime", (Object)value);
    }

    public void setOdataType(@Nullable String value) {
        this.backingStore.set("odataType", (Object)value);
    }

    public void setStartDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("startDateTime", (Object)value);
    }

    public void setTheme(@Nullable ScheduleEntityTheme value) {
        this.backingStore.set("theme", (Object)value);
    }
}

