/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.AggregationOption;
import com.microsoft.graph.models.CollapseProperty;
import com.microsoft.graph.models.EntityType;
import com.microsoft.graph.models.ResultTemplateOption;
import com.microsoft.graph.models.SearchAlterationOptions;
import com.microsoft.graph.models.SearchQuery;
import com.microsoft.graph.models.SharePointOneDriveOptions;
import com.microsoft.graph.models.SortProperty;
import com.microsoft.kiota.serialization.AdditionalDataHolder;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import com.microsoft.kiota.store.BackedModel;
import com.microsoft.kiota.store.BackingStore;
import com.microsoft.kiota.store.BackingStoreFactorySingleton;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class SearchRequest
implements AdditionalDataHolder,
BackedModel,
Parsable {
    @Nonnull
    protected BackingStore backingStore = BackingStoreFactorySingleton.instance.createBackingStore();

    public SearchRequest() {
        this.setAdditionalData(new HashMap<String, Object>());
    }

    @Nonnull
    public static SearchRequest createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new SearchRequest();
    }

    @Nonnull
    public Map<String, Object> getAdditionalData() {
        HashMap<String, Object> value = (HashMap<String, Object>)this.backingStore.get("additionalData");
        if (value == null) {
            value = new HashMap<String, Object>();
            this.setAdditionalData(value);
        }
        return value;
    }

    @Nullable
    public List<String> getAggregationFilters() {
        return (List)this.backingStore.get("aggregationFilters");
    }

    @Nullable
    public List<AggregationOption> getAggregations() {
        return (List)this.backingStore.get("aggregations");
    }

    @Nonnull
    public BackingStore getBackingStore() {
        return this.backingStore;
    }

    @Nullable
    public List<CollapseProperty> getCollapseProperties() {
        return (List)this.backingStore.get("collapseProperties");
    }

    @Nullable
    public List<String> getContentSources() {
        return (List)this.backingStore.get("contentSources");
    }

    @Nullable
    public Boolean getEnableTopResults() {
        return (Boolean)this.backingStore.get("enableTopResults");
    }

    @Nullable
    public List<EntityType> getEntityTypes() {
        return (List)this.backingStore.get("entityTypes");
    }

    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(16);
        deserializerMap.put("aggregationFilters", n -> this.setAggregationFilters(n.getCollectionOfPrimitiveValues(String.class)));
        deserializerMap.put("aggregations", n -> this.setAggregations(n.getCollectionOfObjectValues(AggregationOption::createFromDiscriminatorValue)));
        deserializerMap.put("collapseProperties", n -> this.setCollapseProperties(n.getCollectionOfObjectValues(CollapseProperty::createFromDiscriminatorValue)));
        deserializerMap.put("contentSources", n -> this.setContentSources(n.getCollectionOfPrimitiveValues(String.class)));
        deserializerMap.put("enableTopResults", n -> this.setEnableTopResults(n.getBooleanValue()));
        deserializerMap.put("entityTypes", n -> this.setEntityTypes(n.getCollectionOfEnumValues(EntityType::forValue)));
        deserializerMap.put("fields", n -> this.setFields(n.getCollectionOfPrimitiveValues(String.class)));
        deserializerMap.put("from", n -> this.setFrom(n.getIntegerValue()));
        deserializerMap.put("@odata.type", n -> this.setOdataType(n.getStringValue()));
        deserializerMap.put("query", n -> this.setQuery((SearchQuery)n.getObjectValue(SearchQuery::createFromDiscriminatorValue)));
        deserializerMap.put("queryAlterationOptions", n -> this.setQueryAlterationOptions((SearchAlterationOptions)n.getObjectValue(SearchAlterationOptions::createFromDiscriminatorValue)));
        deserializerMap.put("region", n -> this.setRegion(n.getStringValue()));
        deserializerMap.put("resultTemplateOptions", n -> this.setResultTemplateOptions((ResultTemplateOption)n.getObjectValue(ResultTemplateOption::createFromDiscriminatorValue)));
        deserializerMap.put("sharePointOneDriveOptions", n -> this.setSharePointOneDriveOptions((SharePointOneDriveOptions)n.getObjectValue(SharePointOneDriveOptions::createFromDiscriminatorValue)));
        deserializerMap.put("size", n -> this.setSize(n.getIntegerValue()));
        deserializerMap.put("sortProperties", n -> this.setSortProperties(n.getCollectionOfObjectValues(SortProperty::createFromDiscriminatorValue)));
        return deserializerMap;
    }

    @Nullable
    public List<String> getFields() {
        return (List)this.backingStore.get("fields");
    }

    @Nullable
    public Integer getFrom() {
        return (Integer)this.backingStore.get("from");
    }

    @Nullable
    public String getOdataType() {
        return (String)this.backingStore.get("odataType");
    }

    @Nullable
    public SearchQuery getQuery() {
        return (SearchQuery)this.backingStore.get("query");
    }

    @Nullable
    public SearchAlterationOptions getQueryAlterationOptions() {
        return (SearchAlterationOptions)this.backingStore.get("queryAlterationOptions");
    }

    @Nullable
    public String getRegion() {
        return (String)this.backingStore.get("region");
    }

    @Nullable
    public ResultTemplateOption getResultTemplateOptions() {
        return (ResultTemplateOption)this.backingStore.get("resultTemplateOptions");
    }

    @Nullable
    public SharePointOneDriveOptions getSharePointOneDriveOptions() {
        return (SharePointOneDriveOptions)this.backingStore.get("sharePointOneDriveOptions");
    }

    @Nullable
    public Integer getSize() {
        return (Integer)this.backingStore.get("size");
    }

    @Nullable
    public List<SortProperty> getSortProperties() {
        return (List)this.backingStore.get("sortProperties");
    }

    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        writer.writeCollectionOfPrimitiveValues("aggregationFilters", this.getAggregationFilters());
        writer.writeCollectionOfObjectValues("aggregations", this.getAggregations());
        writer.writeCollectionOfObjectValues("collapseProperties", this.getCollapseProperties());
        writer.writeCollectionOfPrimitiveValues("contentSources", this.getContentSources());
        writer.writeBooleanValue("enableTopResults", this.getEnableTopResults());
        writer.writeCollectionOfEnumValues("entityTypes", this.getEntityTypes());
        writer.writeCollectionOfPrimitiveValues("fields", this.getFields());
        writer.writeIntegerValue("from", this.getFrom());
        writer.writeStringValue("@odata.type", this.getOdataType());
        writer.writeObjectValue("query", (Parsable)this.getQuery(), new Parsable[0]);
        writer.writeObjectValue("queryAlterationOptions", (Parsable)this.getQueryAlterationOptions(), new Parsable[0]);
        writer.writeStringValue("region", this.getRegion());
        writer.writeObjectValue("resultTemplateOptions", (Parsable)this.getResultTemplateOptions(), new Parsable[0]);
        writer.writeObjectValue("sharePointOneDriveOptions", (Parsable)this.getSharePointOneDriveOptions(), new Parsable[0]);
        writer.writeIntegerValue("size", this.getSize());
        writer.writeCollectionOfObjectValues("sortProperties", this.getSortProperties());
        writer.writeAdditionalData(this.getAdditionalData());
    }

    public void setAdditionalData(@Nullable Map<String, Object> value) {
        this.backingStore.set("additionalData", value);
    }

    public void setAggregationFilters(@Nullable List<String> value) {
        this.backingStore.set("aggregationFilters", value);
    }

    public void setAggregations(@Nullable List<AggregationOption> value) {
        this.backingStore.set("aggregations", value);
    }

    public void setBackingStore(@Nonnull BackingStore value) {
        Objects.requireNonNull(value);
        this.backingStore = value;
    }

    public void setCollapseProperties(@Nullable List<CollapseProperty> value) {
        this.backingStore.set("collapseProperties", value);
    }

    public void setContentSources(@Nullable List<String> value) {
        this.backingStore.set("contentSources", value);
    }

    public void setEnableTopResults(@Nullable Boolean value) {
        this.backingStore.set("enableTopResults", (Object)value);
    }

    public void setEntityTypes(@Nullable List<EntityType> value) {
        this.backingStore.set("entityTypes", value);
    }

    public void setFields(@Nullable List<String> value) {
        this.backingStore.set("fields", value);
    }

    public void setFrom(@Nullable Integer value) {
        this.backingStore.set("from", (Object)value);
    }

    public void setOdataType(@Nullable String value) {
        this.backingStore.set("odataType", (Object)value);
    }

    public void setQuery(@Nullable SearchQuery value) {
        this.backingStore.set("query", (Object)value);
    }

    public void setQueryAlterationOptions(@Nullable SearchAlterationOptions value) {
        this.backingStore.set("queryAlterationOptions", (Object)value);
    }

    public void setRegion(@Nullable String value) {
        this.backingStore.set("region", (Object)value);
    }

    public void setResultTemplateOptions(@Nullable ResultTemplateOption value) {
        this.backingStore.set("resultTemplateOptions", (Object)value);
    }

    public void setSharePointOneDriveOptions(@Nullable SharePointOneDriveOptions value) {
        this.backingStore.set("sharePointOneDriveOptions", (Object)value);
    }

    public void setSize(@Nullable Integer value) {
        this.backingStore.set("size", (Object)value);
    }

    public void setSortProperties(@Nullable List<SortProperty> value) {
        this.backingStore.set("sortProperties", value);
    }
}

