/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models.callrecords;

import com.microsoft.kiota.serialization.AdditionalDataHolder;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import com.microsoft.kiota.store.BackedModel;
import com.microsoft.kiota.store.BackingStore;
import com.microsoft.kiota.store.BackingStoreFactorySingleton;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class DirectRoutingLogRow
implements AdditionalDataHolder,
BackedModel,
Parsable {
    @Nonnull
    protected BackingStore backingStore = BackingStoreFactorySingleton.instance.createBackingStore();

    public DirectRoutingLogRow() {
        this.setAdditionalData(new HashMap<String, Object>());
    }

    @Nonnull
    public static DirectRoutingLogRow createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new DirectRoutingLogRow();
    }

    @Nonnull
    public Map<String, Object> getAdditionalData() {
        HashMap<String, Object> value = (HashMap<String, Object>)this.backingStore.get("additionalData");
        if (value == null) {
            value = new HashMap<String, Object>();
            this.setAdditionalData(value);
        }
        return value;
    }

    @Nonnull
    public BackingStore getBackingStore() {
        return this.backingStore;
    }

    @Nullable
    public String getCalleeNumber() {
        return (String)this.backingStore.get("calleeNumber");
    }

    @Nullable
    public Integer getCallEndSubReason() {
        return (Integer)this.backingStore.get("callEndSubReason");
    }

    @Nullable
    public String getCallerNumber() {
        return (String)this.backingStore.get("callerNumber");
    }

    @Nullable
    public String getCallType() {
        return (String)this.backingStore.get("callType");
    }

    @Nullable
    public String getCorrelationId() {
        return (String)this.backingStore.get("correlationId");
    }

    @Nullable
    public Integer getDuration() {
        return (Integer)this.backingStore.get("duration");
    }

    @Nullable
    public OffsetDateTime getEndDateTime() {
        return (OffsetDateTime)this.backingStore.get("endDateTime");
    }

    @Nullable
    public OffsetDateTime getFailureDateTime() {
        return (OffsetDateTime)this.backingStore.get("failureDateTime");
    }

    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(22);
        deserializerMap.put("calleeNumber", n -> this.setCalleeNumber(n.getStringValue()));
        deserializerMap.put("callEndSubReason", n -> this.setCallEndSubReason(n.getIntegerValue()));
        deserializerMap.put("callerNumber", n -> this.setCallerNumber(n.getStringValue()));
        deserializerMap.put("callType", n -> this.setCallType(n.getStringValue()));
        deserializerMap.put("correlationId", n -> this.setCorrelationId(n.getStringValue()));
        deserializerMap.put("duration", n -> this.setDuration(n.getIntegerValue()));
        deserializerMap.put("endDateTime", n -> this.setEndDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("failureDateTime", n -> this.setFailureDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("finalSipCode", n -> this.setFinalSipCode(n.getIntegerValue()));
        deserializerMap.put("finalSipCodePhrase", n -> this.setFinalSipCodePhrase(n.getStringValue()));
        deserializerMap.put("id", n -> this.setId(n.getStringValue()));
        deserializerMap.put("inviteDateTime", n -> this.setInviteDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("mediaBypassEnabled", n -> this.setMediaBypassEnabled(n.getBooleanValue()));
        deserializerMap.put("mediaPathLocation", n -> this.setMediaPathLocation(n.getStringValue()));
        deserializerMap.put("@odata.type", n -> this.setOdataType(n.getStringValue()));
        deserializerMap.put("signalingLocation", n -> this.setSignalingLocation(n.getStringValue()));
        deserializerMap.put("startDateTime", n -> this.setStartDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("successfulCall", n -> this.setSuccessfulCall(n.getBooleanValue()));
        deserializerMap.put("trunkFullyQualifiedDomainName", n -> this.setTrunkFullyQualifiedDomainName(n.getStringValue()));
        deserializerMap.put("userDisplayName", n -> this.setUserDisplayName(n.getStringValue()));
        deserializerMap.put("userId", n -> this.setUserId(n.getStringValue()));
        deserializerMap.put("userPrincipalName", n -> this.setUserPrincipalName(n.getStringValue()));
        return deserializerMap;
    }

    @Nullable
    public Integer getFinalSipCode() {
        return (Integer)this.backingStore.get("finalSipCode");
    }

    @Nullable
    public String getFinalSipCodePhrase() {
        return (String)this.backingStore.get("finalSipCodePhrase");
    }

    @Nullable
    public String getId() {
        return (String)this.backingStore.get("id");
    }

    @Nullable
    public OffsetDateTime getInviteDateTime() {
        return (OffsetDateTime)this.backingStore.get("inviteDateTime");
    }

    @Nullable
    public Boolean getMediaBypassEnabled() {
        return (Boolean)this.backingStore.get("mediaBypassEnabled");
    }

    @Nullable
    public String getMediaPathLocation() {
        return (String)this.backingStore.get("mediaPathLocation");
    }

    @Nullable
    public String getOdataType() {
        return (String)this.backingStore.get("odataType");
    }

    @Nullable
    public String getSignalingLocation() {
        return (String)this.backingStore.get("signalingLocation");
    }

    @Nullable
    public OffsetDateTime getStartDateTime() {
        return (OffsetDateTime)this.backingStore.get("startDateTime");
    }

    @Nullable
    public Boolean getSuccessfulCall() {
        return (Boolean)this.backingStore.get("successfulCall");
    }

    @Nullable
    public String getTrunkFullyQualifiedDomainName() {
        return (String)this.backingStore.get("trunkFullyQualifiedDomainName");
    }

    @Nullable
    public String getUserDisplayName() {
        return (String)this.backingStore.get("userDisplayName");
    }

    @Nullable
    public String getUserId() {
        return (String)this.backingStore.get("userId");
    }

    @Nullable
    public String getUserPrincipalName() {
        return (String)this.backingStore.get("userPrincipalName");
    }

    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        writer.writeStringValue("calleeNumber", this.getCalleeNumber());
        writer.writeIntegerValue("callEndSubReason", this.getCallEndSubReason());
        writer.writeStringValue("callerNumber", this.getCallerNumber());
        writer.writeStringValue("callType", this.getCallType());
        writer.writeStringValue("correlationId", this.getCorrelationId());
        writer.writeIntegerValue("duration", this.getDuration());
        writer.writeOffsetDateTimeValue("endDateTime", this.getEndDateTime());
        writer.writeOffsetDateTimeValue("failureDateTime", this.getFailureDateTime());
        writer.writeIntegerValue("finalSipCode", this.getFinalSipCode());
        writer.writeStringValue("finalSipCodePhrase", this.getFinalSipCodePhrase());
        writer.writeStringValue("id", this.getId());
        writer.writeOffsetDateTimeValue("inviteDateTime", this.getInviteDateTime());
        writer.writeBooleanValue("mediaBypassEnabled", this.getMediaBypassEnabled());
        writer.writeStringValue("mediaPathLocation", this.getMediaPathLocation());
        writer.writeStringValue("@odata.type", this.getOdataType());
        writer.writeStringValue("signalingLocation", this.getSignalingLocation());
        writer.writeOffsetDateTimeValue("startDateTime", this.getStartDateTime());
        writer.writeBooleanValue("successfulCall", this.getSuccessfulCall());
        writer.writeStringValue("trunkFullyQualifiedDomainName", this.getTrunkFullyQualifiedDomainName());
        writer.writeStringValue("userDisplayName", this.getUserDisplayName());
        writer.writeStringValue("userId", this.getUserId());
        writer.writeStringValue("userPrincipalName", this.getUserPrincipalName());
        writer.writeAdditionalData(this.getAdditionalData());
    }

    public void setAdditionalData(@Nullable Map<String, Object> value) {
        this.backingStore.set("additionalData", value);
    }

    public void setBackingStore(@Nonnull BackingStore value) {
        Objects.requireNonNull(value);
        this.backingStore = value;
    }

    public void setCalleeNumber(@Nullable String value) {
        this.backingStore.set("calleeNumber", (Object)value);
    }

    public void setCallEndSubReason(@Nullable Integer value) {
        this.backingStore.set("callEndSubReason", (Object)value);
    }

    public void setCallerNumber(@Nullable String value) {
        this.backingStore.set("callerNumber", (Object)value);
    }

    public void setCallType(@Nullable String value) {
        this.backingStore.set("callType", (Object)value);
    }

    public void setCorrelationId(@Nullable String value) {
        this.backingStore.set("correlationId", (Object)value);
    }

    public void setDuration(@Nullable Integer value) {
        this.backingStore.set("duration", (Object)value);
    }

    public void setEndDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("endDateTime", (Object)value);
    }

    public void setFailureDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("failureDateTime", (Object)value);
    }

    public void setFinalSipCode(@Nullable Integer value) {
        this.backingStore.set("finalSipCode", (Object)value);
    }

    public void setFinalSipCodePhrase(@Nullable String value) {
        this.backingStore.set("finalSipCodePhrase", (Object)value);
    }

    public void setId(@Nullable String value) {
        this.backingStore.set("id", (Object)value);
    }

    public void setInviteDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("inviteDateTime", (Object)value);
    }

    public void setMediaBypassEnabled(@Nullable Boolean value) {
        this.backingStore.set("mediaBypassEnabled", (Object)value);
    }

    public void setMediaPathLocation(@Nullable String value) {
        this.backingStore.set("mediaPathLocation", (Object)value);
    }

    public void setOdataType(@Nullable String value) {
        this.backingStore.set("odataType", (Object)value);
    }

    public void setSignalingLocation(@Nullable String value) {
        this.backingStore.set("signalingLocation", (Object)value);
    }

    public void setStartDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("startDateTime", (Object)value);
    }

    public void setSuccessfulCall(@Nullable Boolean value) {
        this.backingStore.set("successfulCall", (Object)value);
    }

    public void setTrunkFullyQualifiedDomainName(@Nullable String value) {
        this.backingStore.set("trunkFullyQualifiedDomainName", (Object)value);
    }

    public void setUserDisplayName(@Nullable String value) {
        this.backingStore.set("userDisplayName", (Object)value);
    }

    public void setUserId(@Nullable String value) {
        this.backingStore.set("userId", (Object)value);
    }

    public void setUserPrincipalName(@Nullable String value) {
        this.backingStore.set("userPrincipalName", (Object)value);
    }
}

