/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models.security;

import com.microsoft.graph.models.security.AlertEvidence;
import com.microsoft.graph.models.security.IpEvidence;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class DnsEvidence
extends AlertEvidence
implements Parsable {
    public DnsEvidence() {
        this.setOdataType("#microsoft.graph.security.dnsEvidence");
    }

    @Nonnull
    public static DnsEvidence createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new DnsEvidence();
    }

    @Nullable
    public IpEvidence getDnsServerIp() {
        return (IpEvidence)this.backingStore.get("dnsServerIp");
    }

    @Nullable
    public String getDomainName() {
        return (String)this.backingStore.get("domainName");
    }

    @Override
    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("dnsServerIp", n -> this.setDnsServerIp((IpEvidence)n.getObjectValue(IpEvidence::createFromDiscriminatorValue)));
        deserializerMap.put("domainName", n -> this.setDomainName(n.getStringValue()));
        deserializerMap.put("hostIpAddress", n -> this.setHostIpAddress((IpEvidence)n.getObjectValue(IpEvidence::createFromDiscriminatorValue)));
        deserializerMap.put("ipAddresses", n -> this.setIpAddresses(n.getCollectionOfObjectValues(IpEvidence::createFromDiscriminatorValue)));
        return deserializerMap;
    }

    @Nullable
    public IpEvidence getHostIpAddress() {
        return (IpEvidence)this.backingStore.get("hostIpAddress");
    }

    @Nullable
    public List<IpEvidence> getIpAddresses() {
        return (List)this.backingStore.get("ipAddresses");
    }

    @Override
    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeObjectValue("dnsServerIp", (Parsable)this.getDnsServerIp(), new Parsable[0]);
        writer.writeStringValue("domainName", this.getDomainName());
        writer.writeObjectValue("hostIpAddress", (Parsable)this.getHostIpAddress(), new Parsable[0]);
        writer.writeCollectionOfObjectValues("ipAddresses", this.getIpAddresses());
    }

    public void setDnsServerIp(@Nullable IpEvidence value) {
        this.backingStore.set("dnsServerIp", (Object)value);
    }

    public void setDomainName(@Nullable String value) {
        this.backingStore.set("domainName", (Object)value);
    }

    public void setHostIpAddress(@Nullable IpEvidence value) {
        this.backingStore.set("hostIpAddress", (Object)value);
    }

    public void setIpAddresses(@Nullable List<IpEvidence> value) {
        this.backingStore.set("ipAddresses", value);
    }
}

