/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models.security;

import com.microsoft.graph.models.security.EventPropagationStatus;
import com.microsoft.kiota.serialization.AdditionalDataHolder;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import com.microsoft.kiota.store.BackedModel;
import com.microsoft.kiota.store.BackingStore;
import com.microsoft.kiota.store.BackingStoreFactorySingleton;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class EventPropagationResult
implements AdditionalDataHolder,
BackedModel,
Parsable {
    @Nonnull
    protected BackingStore backingStore = BackingStoreFactorySingleton.instance.createBackingStore();

    public EventPropagationResult() {
        this.setAdditionalData(new HashMap<String, Object>());
    }

    @Nonnull
    public static EventPropagationResult createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new EventPropagationResult();
    }

    @Nonnull
    public Map<String, Object> getAdditionalData() {
        HashMap<String, Object> value = (HashMap<String, Object>)this.backingStore.get("additionalData");
        if (value == null) {
            value = new HashMap<String, Object>();
            this.setAdditionalData(value);
        }
        return value;
    }

    @Nonnull
    public BackingStore getBackingStore() {
        return this.backingStore;
    }

    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(5);
        deserializerMap.put("location", n -> this.setLocation(n.getStringValue()));
        deserializerMap.put("@odata.type", n -> this.setOdataType(n.getStringValue()));
        deserializerMap.put("serviceName", n -> this.setServiceName(n.getStringValue()));
        deserializerMap.put("status", n -> this.setStatus((EventPropagationStatus)n.getEnumValue(EventPropagationStatus::forValue)));
        deserializerMap.put("statusInformation", n -> this.setStatusInformation(n.getStringValue()));
        return deserializerMap;
    }

    @Nullable
    public String getLocation() {
        return (String)this.backingStore.get("location");
    }

    @Nullable
    public String getOdataType() {
        return (String)this.backingStore.get("odataType");
    }

    @Nullable
    public String getServiceName() {
        return (String)this.backingStore.get("serviceName");
    }

    @Nullable
    public EventPropagationStatus getStatus() {
        return (EventPropagationStatus)((Object)this.backingStore.get("status"));
    }

    @Nullable
    public String getStatusInformation() {
        return (String)this.backingStore.get("statusInformation");
    }

    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        writer.writeStringValue("location", this.getLocation());
        writer.writeStringValue("@odata.type", this.getOdataType());
        writer.writeStringValue("serviceName", this.getServiceName());
        writer.writeEnumValue("status", (Enum)this.getStatus());
        writer.writeStringValue("statusInformation", this.getStatusInformation());
        writer.writeAdditionalData(this.getAdditionalData());
    }

    public void setAdditionalData(@Nullable Map<String, Object> value) {
        this.backingStore.set("additionalData", value);
    }

    public void setBackingStore(@Nonnull BackingStore value) {
        Objects.requireNonNull(value);
        this.backingStore = value;
    }

    public void setLocation(@Nullable String value) {
        this.backingStore.set("location", (Object)value);
    }

    public void setOdataType(@Nullable String value) {
        this.backingStore.set("odataType", (Object)value);
    }

    public void setServiceName(@Nullable String value) {
        this.backingStore.set("serviceName", (Object)value);
    }

    public void setStatus(@Nullable EventPropagationStatus value) {
        this.backingStore.set("status", (Object)value);
    }

    public void setStatusInformation(@Nullable String value) {
        this.backingStore.set("statusInformation", (Object)value);
    }
}

