/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models.security;

import com.microsoft.graph.models.security.Host;
import com.microsoft.kiota.serialization.AdditionalDataHolder;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import com.microsoft.kiota.store.BackedModel;
import com.microsoft.kiota.store.BackingStore;
import com.microsoft.kiota.store.BackingStoreFactorySingleton;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class WhoisNameserver
implements AdditionalDataHolder,
BackedModel,
Parsable {
    @Nonnull
    protected BackingStore backingStore = BackingStoreFactorySingleton.instance.createBackingStore();

    public WhoisNameserver() {
        this.setAdditionalData(new HashMap<String, Object>());
    }

    @Nonnull
    public static WhoisNameserver createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new WhoisNameserver();
    }

    @Nonnull
    public Map<String, Object> getAdditionalData() {
        HashMap<String, Object> value = (HashMap<String, Object>)this.backingStore.get("additionalData");
        if (value == null) {
            value = new HashMap<String, Object>();
            this.setAdditionalData(value);
        }
        return value;
    }

    @Nonnull
    public BackingStore getBackingStore() {
        return this.backingStore;
    }

    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(4);
        deserializerMap.put("firstSeenDateTime", n -> this.setFirstSeenDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("host", n -> this.setHost((Host)n.getObjectValue(Host::createFromDiscriminatorValue)));
        deserializerMap.put("lastSeenDateTime", n -> this.setLastSeenDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("@odata.type", n -> this.setOdataType(n.getStringValue()));
        return deserializerMap;
    }

    @Nullable
    public OffsetDateTime getFirstSeenDateTime() {
        return (OffsetDateTime)this.backingStore.get("firstSeenDateTime");
    }

    @Nullable
    public Host getHost() {
        return (Host)this.backingStore.get("host");
    }

    @Nullable
    public OffsetDateTime getLastSeenDateTime() {
        return (OffsetDateTime)this.backingStore.get("lastSeenDateTime");
    }

    @Nullable
    public String getOdataType() {
        return (String)this.backingStore.get("odataType");
    }

    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        writer.writeOffsetDateTimeValue("firstSeenDateTime", this.getFirstSeenDateTime());
        writer.writeObjectValue("host", (Parsable)this.getHost(), new Parsable[0]);
        writer.writeOffsetDateTimeValue("lastSeenDateTime", this.getLastSeenDateTime());
        writer.writeStringValue("@odata.type", this.getOdataType());
        writer.writeAdditionalData(this.getAdditionalData());
    }

    public void setAdditionalData(@Nullable Map<String, Object> value) {
        this.backingStore.set("additionalData", value);
    }

    public void setBackingStore(@Nonnull BackingStore value) {
        Objects.requireNonNull(value);
        this.backingStore = value;
    }

    public void setFirstSeenDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("firstSeenDateTime", (Object)value);
    }

    public void setHost(@Nullable Host value) {
        this.backingStore.set("host", (Object)value);
    }

    public void setLastSeenDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("lastSeenDateTime", (Object)value);
    }

    public void setOdataType(@Nullable String value) {
        this.backingStore.set("odataType", (Object)value);
    }
}

