/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.kiota.serialization;

import com.microsoft.kiota.serialization.FormSerializationWriter;
import com.microsoft.kiota.serialization.SerializationWriter;
import com.microsoft.kiota.serialization.SerializationWriterFactory;
import jakarta.annotation.Nonnull;
import java.util.Objects;

public class FormSerializationWriterFactory
implements SerializationWriterFactory {
    private static final String validContentType = "application/x-www-form-urlencoded";

    @Nonnull
    public String getValidContentType() {
        return validContentType;
    }

    @Nonnull
    public SerializationWriter getSerializationWriter(@Nonnull String contentType) {
        Objects.requireNonNull(contentType, "parameter contentType cannot be null");
        if (contentType.isEmpty()) {
            throw new NullPointerException("contentType cannot be empty");
        }
        if (!contentType.equals(validContentType)) {
            throw new IllegalArgumentException("expected a application/x-www-form-urlencoded content type");
        }
        return new FormSerializationWriter();
    }
}

