/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.spring.data.gremlin.common;

import com.microsoft.spring.data.gremlin.common.GremlinConfig;
import com.microsoft.spring.data.gremlin.exception.GremlinIllegalConfigurationException;
import com.microsoft.spring.data.gremlin.telemetry.TelemetrySender;
import javax.annotation.PostConstruct;
import org.apache.tinkerpop.gremlin.driver.Client;
import org.apache.tinkerpop.gremlin.driver.Cluster;
import org.apache.tinkerpop.gremlin.driver.ser.Serializers;
import org.springframework.lang.NonNull;

public class GremlinFactory {
    private Cluster gremlinCluster;
    private GremlinConfig gremlinConfig;

    public GremlinFactory(@NonNull GremlinConfig gremlinConfig) {
        int port = gremlinConfig.getPort();
        if (port <= 0 || port > 65535) {
            gremlinConfig.setPort(443);
        }
        this.gremlinConfig = gremlinConfig;
    }

    private Cluster createGremlinCluster() throws GremlinIllegalConfigurationException {
        Cluster cluster;
        try {
            cluster = Cluster.build((String)this.gremlinConfig.getEndpoint()).serializer(Serializers.valueOf((String)this.gremlinConfig.getSerializer()).simpleInstance()).credentials(this.gremlinConfig.getUsername(), this.gremlinConfig.getPassword()).enableSsl(this.gremlinConfig.isSslEnabled()).port(this.gremlinConfig.getPort()).create();
        }
        catch (IllegalArgumentException e) {
            throw new GremlinIllegalConfigurationException("Invalid configuration of Gremlin", e);
        }
        return cluster;
    }

    public Client getGremlinClient() {
        if (this.gremlinCluster == null) {
            this.gremlinCluster = this.createGremlinCluster();
        }
        return this.gremlinCluster.connect();
    }

    @PostConstruct
    private void sendTelemetry() {
        if (this.gremlinConfig.isTelemetryAllowed()) {
            TelemetrySender sender = new TelemetrySender();
            sender.send(this.getClass().getSimpleName());
        }
    }
}

