/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.spring.data.gremlin.config;

import com.microsoft.spring.data.gremlin.mapping.GremlinMappingContext;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.data.annotation.Persistent;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mapping.context.MappingContextIsNewStrategyFactory;
import org.springframework.data.mapping.context.PersistentEntities;
import org.springframework.data.support.CachingIsNewStrategyFactory;
import org.springframework.data.support.IsNewStrategyFactory;
import org.springframework.lang.NonNull;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public abstract class GremlinConfigurationSupport {
    protected Collection<String> getMappingBasePackages() {
        Package basePackage = this.getClass().getPackage();
        return Collections.singleton(basePackage == null ? null : basePackage.getName());
    }

    protected Set<Class<?>> scanEntities(@NonNull String basePackage) throws ClassNotFoundException {
        if (!StringUtils.hasText((String)basePackage)) {
            return Collections.emptySet();
        }
        HashSet entitySet = new HashSet();
        ClassPathScanningCandidateComponentProvider provider = new ClassPathScanningCandidateComponentProvider(false);
        provider.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(Persistent.class));
        for (BeanDefinition candidate : provider.findCandidateComponents(basePackage)) {
            String className = candidate.getBeanClassName();
            Assert.notNull((Object)GremlinConfigurationSupport.class.getClassLoader(), (String)"Class loader cannot be null");
            entitySet.add(ClassUtils.forName((String)className, (ClassLoader)GremlinConfigurationSupport.class.getClassLoader()));
        }
        return entitySet;
    }

    protected Set<Class<?>> getInitialEntitySet() throws ClassNotFoundException {
        HashSet entitySet = new HashSet();
        for (String basePackage : this.getMappingBasePackages()) {
            entitySet.addAll(this.scanEntities(basePackage));
        }
        return entitySet;
    }

    @Bean
    public GremlinMappingContext gremlinMappingContext() throws ClassNotFoundException {
        GremlinMappingContext context = new GremlinMappingContext();
        context.setInitialEntitySet(this.getInitialEntitySet());
        return context;
    }

    @Bean
    public IsNewStrategyFactory isNewStrategyFactory() throws ClassNotFoundException {
        PersistentEntities entities = new PersistentEntities(Arrays.asList(new MappingContext[]{this.gremlinMappingContext()}));
        return new CachingIsNewStrategyFactory((IsNewStrategyFactory)new MappingContextIsNewStrategyFactory(entities));
    }
}

