/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.spring.data.gremlin.conversion.result;

import com.microsoft.spring.data.gremlin.common.GremlinUtils;
import com.microsoft.spring.data.gremlin.conversion.result.AbstractGremlinResultReader;
import com.microsoft.spring.data.gremlin.conversion.result.GremlinResultsReader;
import com.microsoft.spring.data.gremlin.conversion.source.GremlinSource;
import com.microsoft.spring.data.gremlin.conversion.source.GremlinSourceEdge;
import com.microsoft.spring.data.gremlin.exception.GremlinUnexpectedSourceTypeException;
import java.util.List;
import java.util.Map;
import lombok.NonNull;
import org.apache.tinkerpop.gremlin.driver.Result;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class GremlinResultEdgeReader
extends AbstractGremlinResultReader
implements GremlinResultsReader {
    private void readProperties(@NonNull GremlinSource source, @Nullable Map map) {
        if (source == null) {
            throw new NullPointerException("source");
        }
        if (map != null) {
            Map properties = map;
            properties.forEach(source::setProperty);
        }
    }

    private void validate(List<Result> results, GremlinSource source) {
        Assert.notNull(results, (String)"Results should not be null.");
        Assert.notNull((Object)source, (String)"GremlinSource should not be null.");
        Assert.isTrue((results.size() == 1 ? 1 : 0) != 0, (String)"Edge should contain only one result.");
        Result result = results.get(0);
        Assert.isInstanceOf(Map.class, (Object)result.getObject(), (String)"should be one instance of Map");
        Map map = (Map)result.getObject();
        Assert.isTrue((boolean)map.containsKey("id"), (String)"should contain id property");
        Assert.isTrue((boolean)map.containsKey("label"), (String)"should contain label property");
        Assert.isTrue((boolean)map.containsKey("type"), (String)"should contain type property");
        Assert.isTrue((boolean)map.containsKey("inV"), (String)"should contain inV property");
        Assert.isTrue((boolean)map.containsKey("outV"), (String)"should contain outV property");
        Assert.isTrue((boolean)map.get("type").equals("edge"), (String)"must be vertex type");
    }

    @Override
    public void read(@NonNull List<Result> results, @NonNull GremlinSource source) {
        if (results == null) {
            throw new NullPointerException("results");
        }
        if (source == null) {
            throw new NullPointerException("source");
        }
        if (!(source instanceof GremlinSourceEdge)) {
            throw new GremlinUnexpectedSourceTypeException("Should be instance of GremlinSourceEdge");
        }
        this.validate(results, source);
        GremlinSourceEdge sourceEdge = (GremlinSourceEdge)source;
        Map map = (Map)results.get(0).getObject();
        this.readProperties(source, (Map)map.get("properties"));
        String className = source.getProperties().get("_classname").toString();
        sourceEdge.setIdField(GremlinUtils.getIdField(GremlinUtils.toEntityClass(className)));
        sourceEdge.setId(map.get("id"));
        sourceEdge.setLabel(map.get("label").toString());
        sourceEdge.setVertexIdFrom(map.get("outV"));
        sourceEdge.setVertexIdTo(map.get("inV"));
    }
}

