/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.spring.data.gremlin.conversion.script;

import com.microsoft.spring.data.gremlin.annotation.GeneratedValue;
import com.microsoft.spring.data.gremlin.common.GremlinEntityType;
import com.microsoft.spring.data.gremlin.common.GremlinUtils;
import com.microsoft.spring.data.gremlin.exception.GremlinInvalidEntityIdFieldException;
import com.microsoft.spring.data.gremlin.exception.GremlinUnexpectedEntityTypeException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import lombok.NonNull;
import org.apache.tinkerpop.shaded.jackson.core.JsonProcessingException;
import org.springframework.util.Assert;

public abstract class AbstractGremlinScriptLiteral {
    protected static String generateEntityWithRequiredId(@NonNull Object id, GremlinEntityType type) {
        String prefix;
        if (id == null) {
            throw new NullPointerException("id");
        }
        Assert.isTrue((type == GremlinEntityType.EDGE || type == GremlinEntityType.VERTEX ? 1 : 0) != 0, (String)"should be edge/vertex type");
        String string = prefix = type == GremlinEntityType.VERTEX ? "V" : "E";
        if (id instanceof String) {
            return prefix + String.format("('%s')", (String)id);
        }
        if (id instanceof Integer) {
            return prefix + String.format("(%d)", (Integer)id);
        }
        if (id instanceof Long) {
            return prefix + String.format("(%d)", (Long)id);
        }
        throw new GremlinInvalidEntityIdFieldException("Only String/Integer/Long of id is supported");
    }

    protected static String generatePropertyWithRequiredId(@NonNull Object id) {
        if (id == null) {
            throw new NullPointerException("id");
        }
        if (id instanceof String) {
            return String.format("property(id, '%s')", (String)id);
        }
        if (id instanceof Integer) {
            return String.format("property(id, %d)", (Integer)id);
        }
        if (id instanceof Long) {
            return String.format("property(id, %d)", (Long)id);
        }
        throw new GremlinInvalidEntityIdFieldException("Only String/Integer/Long of id is supported");
    }

    protected static String generateAsWithAlias(@NonNull String alias) {
        if (alias == null) {
            throw new NullPointerException("alias");
        }
        return String.format("as('%s')", alias);
    }

    protected static String generateAddEntityWithLabel(@NonNull String label, GremlinEntityType type) {
        if (label == null) {
            throw new NullPointerException("label");
        }
        Assert.isTrue((type == GremlinEntityType.EDGE || type == GremlinEntityType.VERTEX ? 1 : 0) != 0, (String)"should be edge/vertex type");
        String prefix = type == GremlinEntityType.VERTEX ? "addV" : "addE";
        return prefix + String.format("('%s')", label);
    }

    protected static List<String> completeScript(@NonNull List<String> scriptList) {
        if (scriptList == null) {
            throw new NullPointerException("scriptList");
        }
        return Collections.singletonList(String.join((CharSequence)".", scriptList));
    }

    public static String generateHasLabel(@NonNull String label) {
        if (label == null) {
            throw new NullPointerException("label");
        }
        return String.format("has(label, '%s')", label);
    }

    public static String generateHasId(@NonNull Object id) {
        if (id == null) {
            throw new NullPointerException("id");
        }
        if (id instanceof String) {
            return String.format("hasId('%s')", id);
        }
        if (id instanceof Integer) {
            return String.format("hasId(%d)", (Integer)id);
        }
        if (id instanceof Long) {
            return String.format("hasId(%d)", (Long)id);
        }
        throw new GremlinInvalidEntityIdFieldException("the type of @Id/id field should be String/Integer/Long");
    }

    public static String generateHasId(@NonNull Object id, @NonNull Field idFiled) {
        if (id == null) {
            throw new NullPointerException("id");
        }
        if (idFiled == null) {
            throw new NullPointerException("idFiled");
        }
        if (!idFiled.isAnnotationPresent(GeneratedValue.class)) {
            return AbstractGremlinScriptLiteral.generateHasId(id);
        }
        if (id instanceof String) {
            return String.format("hasId('%s')", id);
        }
        if (id instanceof Integer) {
            return String.format("hasId(%dL)", (Integer)id);
        }
        if (id instanceof Long) {
            return String.format("hasId(%dL)", (Long)id);
        }
        throw new GremlinInvalidEntityIdFieldException("the type of @Id/id field should be String/Integer/Long");
    }

    private static String generateProperty(@NonNull String name, @NonNull String value) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (value == null) {
            throw new NullPointerException("value");
        }
        return String.format("property('%s', '%s')", name, value);
    }

    private static String generateProperty(@NonNull String name, @NonNull Integer value) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (value == null) {
            throw new NullPointerException("value");
        }
        return String.format("property('%s', %d)", name, value);
    }

    private static String generateProperty(@NonNull String name, @NonNull Boolean value) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (value == null) {
            throw new NullPointerException("value");
        }
        return String.format("property('%s', %b)", name, value);
    }

    private static String generateProperty(@NonNull String name, @NonNull Long value) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (value == null) {
            throw new NullPointerException("value");
        }
        return String.format("property('%s', %d)", name, value);
    }

    private static String generateProperty(@NonNull String name, @NonNull Object value) {
        String propertyScript;
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (value == null) {
            throw new NullPointerException("value");
        }
        if (value instanceof Integer) {
            return AbstractGremlinScriptLiteral.generateProperty(name, (Integer)value);
        }
        if (value instanceof Boolean) {
            return AbstractGremlinScriptLiteral.generateProperty(name, (Boolean)value);
        }
        if (value instanceof String) {
            return AbstractGremlinScriptLiteral.generateProperty(name, (String)value);
        }
        if (value instanceof Date) {
            return AbstractGremlinScriptLiteral.generateProperty(name, GremlinUtils.timeToMilliSeconds(value));
        }
        try {
            propertyScript = AbstractGremlinScriptLiteral.generateProperty(name, GremlinUtils.getObjectMapper().writeValueAsString(value));
        }
        catch (JsonProcessingException e) {
            throw new GremlinUnexpectedEntityTypeException("Failed to write object to String", e);
        }
        return propertyScript;
    }

    protected static List<String> generateProperties(@NonNull Map<String, Object> properties) {
        if (properties == null) {
            throw new NullPointerException("properties");
        }
        ArrayList<String> scripts = new ArrayList<String>();
        properties.entrySet().stream().filter(e -> e.getValue() != null).forEach(e -> scripts.add(AbstractGremlinScriptLiteral.generateProperty((String)e.getKey(), e.getValue())));
        return scripts;
    }

    private static String generateHas(@NonNull String name, @NonNull Integer value) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (value == null) {
            throw new NullPointerException("value");
        }
        return String.format("has('%s', %d)", name, value);
    }

    private static String generateHas(@NonNull String name, @NonNull Boolean value) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (value == null) {
            throw new NullPointerException("value");
        }
        return String.format("has('%s', %b)", name, value);
    }

    private static String generateHas(@NonNull String name, @NonNull String value) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (value == null) {
            throw new NullPointerException("value");
        }
        return String.format("has('%s', '%s')", name, value);
    }

    private static String generateHas(@NonNull String name, @NonNull Long value) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (value == null) {
            throw new NullPointerException("value");
        }
        return String.format("has('%s', %d)", name, value);
    }

    public static String generateHas(@NonNull String name, @NonNull Object value) {
        String hasScript;
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (value == null) {
            throw new NullPointerException("value");
        }
        if (value instanceof Integer) {
            return AbstractGremlinScriptLiteral.generateHas(name, (Integer)value);
        }
        if (value instanceof Boolean) {
            return AbstractGremlinScriptLiteral.generateHas(name, (Boolean)value);
        }
        if (value instanceof String) {
            return AbstractGremlinScriptLiteral.generateHas(name, (String)value);
        }
        if (value instanceof Date) {
            return AbstractGremlinScriptLiteral.generateHas(name, GremlinUtils.timeToMilliSeconds(value));
        }
        try {
            hasScript = AbstractGremlinScriptLiteral.generateHas(name, GremlinUtils.getObjectMapper().writeValueAsString(value));
        }
        catch (JsonProcessingException e) {
            throw new GremlinUnexpectedEntityTypeException("Failed to write object to String", e);
        }
        return hasScript;
    }
}

