/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.spring.data.gremlin.conversion.script;

import com.microsoft.spring.data.gremlin.common.Constants;
import com.microsoft.spring.data.gremlin.common.GremlinEntityType;
import com.microsoft.spring.data.gremlin.conversion.script.AbstractGremlinScriptLiteral;
import com.microsoft.spring.data.gremlin.conversion.script.GremlinScriptLiteral;
import com.microsoft.spring.data.gremlin.conversion.source.GremlinSource;
import com.microsoft.spring.data.gremlin.conversion.source.GremlinSourceEdge;
import com.microsoft.spring.data.gremlin.exception.GremlinUnexpectedSourceTypeException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import lombok.NonNull;
import org.springframework.util.Assert;

public class GremlinScriptLiteralEdge
extends AbstractGremlinScriptLiteral
implements GremlinScriptLiteral {
    private static final String FROM_ALIAS = "from";
    private static final String TO_ALIAS = "to";

    private String generateEdgeDirection(@NonNull String from, @NonNull String to) {
        if (from == null) {
            throw new NullPointerException(FROM_ALIAS);
        }
        if (to == null) {
            throw new NullPointerException(TO_ALIAS);
        }
        return String.format("from('%s').to('%s')", from, to);
    }

    @Override
    public List<String> generateInsertScript(@NonNull GremlinSource source) {
        if (source == null) {
            throw new NullPointerException("source");
        }
        if (!(source instanceof GremlinSourceEdge)) {
            throw new GremlinUnexpectedSourceTypeException("should be the instance of GremlinSourceEdge");
        }
        GremlinSourceEdge sourceEdge = (GremlinSourceEdge)source;
        ArrayList<String> scriptList = new ArrayList<String>();
        scriptList.add("g");
        scriptList.add(GremlinScriptLiteralEdge.generateEntityWithRequiredId(sourceEdge.getVertexIdFrom(), GremlinEntityType.VERTEX));
        scriptList.add(GremlinScriptLiteralEdge.generateAsWithAlias(FROM_ALIAS));
        scriptList.add(GremlinScriptLiteralEdge.generateEntityWithRequiredId(sourceEdge.getVertexIdTo(), GremlinEntityType.VERTEX));
        scriptList.add(GremlinScriptLiteralEdge.generateAsWithAlias(TO_ALIAS));
        scriptList.add(GremlinScriptLiteralEdge.generateAddEntityWithLabel(sourceEdge.getLabel(), GremlinEntityType.EDGE));
        scriptList.add(this.generateEdgeDirection(FROM_ALIAS, TO_ALIAS));
        source.getId().ifPresent(id -> scriptList.add(GremlinScriptLiteralEdge.generatePropertyWithRequiredId(id)));
        scriptList.addAll(GremlinScriptLiteralEdge.generateProperties(source.getProperties()));
        return GremlinScriptLiteralEdge.completeScript(scriptList);
    }

    @Override
    public List<String> generateDeleteAllScript() {
        return Collections.singletonList(Constants.GREMLIN_SCRIPT_EDGE_DROP_ALL);
    }

    @Override
    public List<String> generateDeleteAllByClassScript(@NonNull GremlinSource source) {
        if (source == null) {
            throw new NullPointerException("source");
        }
        if (!(source instanceof GremlinSourceEdge)) {
            throw new GremlinUnexpectedSourceTypeException("should be the instance of GremlinSourceEdge");
        }
        List<String> scriptList = Arrays.asList("g", "E()", GremlinScriptLiteralEdge.generateHasLabel(source.getLabel()), "drop()");
        return GremlinScriptLiteralEdge.completeScript(scriptList);
    }

    @Override
    public List<String> generateFindByIdScript(@NonNull GremlinSource source) {
        if (source == null) {
            throw new NullPointerException("source");
        }
        if (!(source instanceof GremlinSourceEdge)) {
            throw new GremlinUnexpectedSourceTypeException("should be the instance of GremlinSourceEdge");
        }
        Assert.isTrue((boolean)source.getId().isPresent(), (String)"GremlinSource should contain id.");
        List<String> scriptList = Arrays.asList("g", "E()", GremlinScriptLiteralEdge.generateHasId(source.getId().get(), source.getIdField()));
        return GremlinScriptLiteralEdge.completeScript(scriptList);
    }

    @Override
    public List<String> generateUpdateScript(@NonNull GremlinSource source) {
        if (source == null) {
            throw new NullPointerException("source");
        }
        if (!(source instanceof GremlinSourceEdge)) {
            throw new GremlinUnexpectedSourceTypeException("should be the instance of GremlinSourceEdge");
        }
        ArrayList<String> scriptList = new ArrayList<String>();
        Assert.isTrue((boolean)source.getId().isPresent(), (String)"GremlinSource should contain id.");
        scriptList.add("g");
        scriptList.add(GremlinScriptLiteralEdge.generateEntityWithRequiredId(source.getId().get(), GremlinEntityType.EDGE));
        scriptList.addAll(GremlinScriptLiteralEdge.generateProperties(source.getProperties()));
        return GremlinScriptLiteralEdge.completeScript(scriptList);
    }

    @Override
    public List<String> generateFindAllScript(@NonNull GremlinSource source) {
        if (source == null) {
            throw new NullPointerException("source");
        }
        if (!(source instanceof GremlinSourceEdge)) {
            throw new GremlinUnexpectedSourceTypeException("should be the instance of GremlinSourceEdge");
        }
        String className = source.getProperties().get("_classname").toString();
        Assert.notNull((Object)className, (String)"GremlinSource should contain predefined className");
        List<String> scriptList = Arrays.asList("g", "E()", GremlinScriptLiteralEdge.generateHasLabel(source.getLabel()), GremlinScriptLiteralEdge.generateHas("_classname", (Object)className));
        return GremlinScriptLiteralEdge.completeScript(scriptList);
    }

    @Override
    public List<String> generateDeleteByIdScript(@NonNull GremlinSource source) {
        if (source == null) {
            throw new NullPointerException("source");
        }
        if (!(source instanceof GremlinSourceEdge)) {
            throw new GremlinUnexpectedSourceTypeException("should be the instance of GremlinSourceEdge");
        }
        Assert.isTrue((boolean)source.getId().isPresent(), (String)"GremlinSource should contain id.");
        List<String> scriptList = Arrays.asList("g", "E()", GremlinScriptLiteralEdge.generateHasId(source.getId().get(), source.getIdField()), "drop()");
        return GremlinScriptLiteralEdge.completeScript(scriptList);
    }

    @Override
    public List<String> generateCountScript(@NonNull GremlinSource source) {
        if (source == null) {
            throw new NullPointerException("source");
        }
        if (!(source instanceof GremlinSourceEdge)) {
            throw new GremlinUnexpectedSourceTypeException("should be the instance of GremlinSourceEdge");
        }
        return Collections.singletonList(Constants.GREMLIN_SCRIPT_EDGE_ALL);
    }
}

