/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.spring.data.gremlin.conversion.script;

import com.microsoft.spring.data.gremlin.common.Constants;
import com.microsoft.spring.data.gremlin.conversion.script.GremlinScriptLiteral;
import com.microsoft.spring.data.gremlin.conversion.script.GremlinScriptLiteralEdge;
import com.microsoft.spring.data.gremlin.conversion.script.GremlinScriptLiteralVertex;
import com.microsoft.spring.data.gremlin.conversion.source.GremlinSource;
import com.microsoft.spring.data.gremlin.conversion.source.GremlinSourceGraph;
import com.microsoft.spring.data.gremlin.exception.GremlinUnexpectedSourceTypeException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;

public class GremlinScriptLiteralGraph
implements GremlinScriptLiteral {
    private final GremlinScriptLiteralVertex scriptVertex = new GremlinScriptLiteralVertex();
    private final GremlinScriptLiteralEdge scriptEdge = new GremlinScriptLiteralEdge();

    @Override
    public List<String> generateInsertScript(@NonNull GremlinSource source) {
        return this.generateInsertUpdateScript(source, this.scriptVertex::generateInsertScript, this.scriptEdge::generateInsertScript);
    }

    @Override
    public List<String> generateDeleteAllScript() {
        return Arrays.asList(Constants.GREMLIN_SCRIPT_EDGE_DROP_ALL, "barrier", Constants.GREMLIN_SCRIPT_VERTEX_DROP_ALL);
    }

    @Override
    public List<String> generateDeleteAllByClassScript(@NonNull GremlinSource source) {
        return this.generateDeleteAllScript();
    }

    @Override
    public List<String> generateFindByIdScript(@Nullable GremlinSource source) {
        throw new UnsupportedOperationException("Gremlin graph cannot findById by single query.");
    }

    @Override
    public List<String> generateUpdateScript(@NonNull GremlinSource source) {
        return this.generateInsertUpdateScript(source, this.scriptVertex::generateUpdateScript, this.scriptEdge::generateUpdateScript);
    }

    private List<String> generateInsertUpdateScript(@NonNull GremlinSource source, @NonNull Function<GremlinSource, List<String>> vertexHandler, @NonNull Function<GremlinSource, List<String>> edgeHandler) {
        if (!(source instanceof GremlinSourceGraph)) {
            throw new GremlinUnexpectedSourceTypeException("should be the instance of GremlinSourceGraph");
        }
        ArrayList<String> scriptList = new ArrayList<String>();
        GremlinSourceGraph sourceGraph = (GremlinSourceGraph)source;
        List<GremlinSource> vertexes = sourceGraph.getVertexSet();
        List<GremlinSource> edges = sourceGraph.getEdgeSet();
        vertexes.forEach(vertex -> scriptList.addAll((Collection)vertexHandler.apply((GremlinSource)vertex)));
        scriptList.add("barrier");
        edges.forEach(edge -> scriptList.addAll((Collection)edgeHandler.apply((GremlinSource)edge)));
        return scriptList;
    }

    @Override
    public List<String> generateDeleteByIdScript(@NonNull GremlinSource source) {
        if (!(source instanceof GremlinSourceGraph)) {
            throw new GremlinUnexpectedSourceTypeException("should be the instance of GremlinSourceGraph");
        }
        return this.generateDeleteAllScript();
    }

    @Override
    public List<String> generateFindAllScript(@NonNull GremlinSource source) {
        throw new UnsupportedOperationException("Gremlin graph cannot be findAll.");
    }

    public List<String> generateIsEmptyScript() {
        List<String> scriptList = Arrays.asList("g", "V()");
        String query = String.join((CharSequence)".", scriptList);
        return Collections.singletonList(query);
    }

    @Override
    public List<String> generateCountScript(@NonNull GremlinSource source) {
        throw new UnsupportedOperationException("Gremlin graph counting is not available.");
    }
}

