/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.spring.data.gremlin.conversion.source;

import com.microsoft.spring.data.gremlin.conversion.result.GremlinResultsGraphReader;
import com.microsoft.spring.data.gremlin.conversion.result.GremlinResultsReader;
import com.microsoft.spring.data.gremlin.conversion.script.GremlinScriptLiteralGraph;
import com.microsoft.spring.data.gremlin.conversion.source.AbstractGremlinSource;
import com.microsoft.spring.data.gremlin.conversion.source.GremlinSource;
import com.microsoft.spring.data.gremlin.conversion.source.GremlinSourceEdge;
import com.microsoft.spring.data.gremlin.conversion.source.GremlinSourceGraphReader;
import com.microsoft.spring.data.gremlin.conversion.source.GremlinSourceGraphWriter;
import com.microsoft.spring.data.gremlin.conversion.source.GremlinSourceVertex;
import com.microsoft.spring.data.gremlin.exception.GremlinUnexpectedSourceTypeException;
import java.util.ArrayList;
import java.util.List;

public class GremlinSourceGraph<T>
extends AbstractGremlinSource<T> {
    private List<GremlinSource> vertexSet = new ArrayList<GremlinSource>();
    private List<GremlinSource> edgeSet = new ArrayList<GremlinSource>();
    private GremlinResultsReader resultsReader;

    public GremlinSourceGraph() {
        this.initializeGremlinStrategy();
        this.setGremlinSourceReader(new GremlinSourceGraphReader());
        this.resultsReader = new GremlinResultsGraphReader();
    }

    public GremlinSourceGraph(Class<T> domainClass) {
        super(domainClass);
        this.initializeGremlinStrategy();
        this.setGremlinSourceReader(new GremlinSourceGraphReader());
        this.resultsReader = new GremlinResultsGraphReader();
    }

    public void addGremlinSource(GremlinSource source) {
        if (source instanceof GremlinSourceVertex) {
            this.vertexSet.add(source);
        } else if (source instanceof GremlinSourceEdge) {
            this.edgeSet.add(source);
        } else {
            throw new GremlinUnexpectedSourceTypeException("source type can only be Vertex or Edge");
        }
    }

    private void initializeGremlinStrategy() {
        this.setGremlinScriptStrategy(new GremlinScriptLiteralGraph());
        this.setGremlinSourceWriter(new GremlinSourceGraphWriter());
    }

    public List<GremlinSource> getVertexSet() {
        return this.vertexSet;
    }

    public List<GremlinSource> getEdgeSet() {
        return this.edgeSet;
    }

    public GremlinResultsReader getResultsReader() {
        return this.resultsReader;
    }
}

