/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.spring.data.gremlin.conversion.source;

import com.microsoft.spring.data.gremlin.annotation.EdgeSet;
import com.microsoft.spring.data.gremlin.annotation.VertexSet;
import com.microsoft.spring.data.gremlin.common.GremlinUtils;
import com.microsoft.spring.data.gremlin.conversion.MappingGremlinConverter;
import com.microsoft.spring.data.gremlin.conversion.source.AbstractGremlinSourceReader;
import com.microsoft.spring.data.gremlin.conversion.source.GremlinSource;
import com.microsoft.spring.data.gremlin.conversion.source.GremlinSourceGraph;
import com.microsoft.spring.data.gremlin.conversion.source.GremlinSourceReader;
import com.microsoft.spring.data.gremlin.exception.GremlinUnexpectedSourceTypeException;
import com.microsoft.spring.data.gremlin.mapping.GremlinPersistentEntity;
import com.microsoft.spring.data.gremlin.repository.support.GremlinEntityInformation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.springframework.data.annotation.Id;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.model.ConvertingPropertyAccessor;
import org.springframework.lang.NonNull;

public class GremlinSourceGraphReader
extends AbstractGremlinSourceReader
implements GremlinSourceReader {
    @Override
    public <T> T read(@NonNull Class<T> type, @NonNull MappingGremlinConverter converter, @NonNull GremlinSource<T> source) {
        if (!(source instanceof GremlinSourceGraph)) {
            throw new GremlinUnexpectedSourceTypeException("Should be instance of GremlinSourceGraph");
        }
        GremlinSourceGraph graphSource = (GremlinSourceGraph)source;
        T entity = GremlinUtils.createInstance(type);
        ConvertingPropertyAccessor accessor = converter.getPropertyAccessor(entity);
        GremlinPersistentEntity<?> persistentEntity = converter.getPersistentEntity(type);
        for (Field field : FieldUtils.getAllFields(type)) {
            PersistentProperty property = persistentEntity.getPersistentProperty(field.getName());
            if (property == null) continue;
            if (field.getName().equals("id") || field.getAnnotation(Id.class) != null) {
                accessor.setProperty(property, super.getGremlinSourceId(graphSource));
                continue;
            }
            if (field.isAnnotationPresent(VertexSet.class)) {
                accessor.setProperty(property, this.readEntitySet(graphSource.getVertexSet(), converter));
                continue;
            }
            if (!field.isAnnotationPresent(EdgeSet.class)) continue;
            accessor.setProperty(property, this.readEntitySet(graphSource.getEdgeSet(), converter));
        }
        return entity;
    }

    private List<Object> readEntitySet(List<GremlinSource> sources, MappingGremlinConverter converter) {
        ArrayList<Object> domainObjects = new ArrayList<Object>();
        for (GremlinSource source : sources) {
            Class<?> domainClass;
            try {
                domainClass = Class.forName((String)source.getProperties().get("_classname"));
            }
            catch (ClassNotFoundException e) {
                throw new GremlinUnexpectedSourceTypeException("No Java class found for source property _classname", e);
            }
            source.setIdField(new GremlinEntityInformation(domainClass).getIdField());
            domainObjects.add(source.doGremlinSourceRead(domainClass, converter));
        }
        return domainObjects;
    }
}

