/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.spring.data.gremlin.query.query;

import com.microsoft.spring.data.gremlin.common.GremlinUtils;
import com.microsoft.spring.data.gremlin.conversion.script.AbstractGremlinScriptLiteral;
import com.microsoft.spring.data.gremlin.conversion.source.GremlinSource;
import com.microsoft.spring.data.gremlin.conversion.source.GremlinSourceEdge;
import com.microsoft.spring.data.gremlin.conversion.source.GremlinSourceVertex;
import com.microsoft.spring.data.gremlin.query.criteria.Criteria;
import com.microsoft.spring.data.gremlin.query.criteria.CriteriaType;
import com.microsoft.spring.data.gremlin.query.query.GremlinQuery;
import com.microsoft.spring.data.gremlin.query.query.QueryScriptGenerator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springframework.lang.NonNull;

public class QueryFindScriptGenerator
implements QueryScriptGenerator {
    private final GremlinSource source;

    public QueryFindScriptGenerator(@NonNull GremlinSource source) {
        this.source = source;
    }

    private String getCriteriaSubject(@NonNull Criteria criteria) {
        String subject = criteria.getSubject();
        if (subject.equals(this.source.getIdField().getName())) {
            subject = "id";
        }
        return subject;
    }

    private String generateIsEqual(@NonNull Criteria criteria) {
        String subject = this.getCriteriaSubject(criteria);
        if (subject.equals("id")) {
            return String.format("where(%s)", AbstractGremlinScriptLiteral.generateHasId(criteria.getSubValues().get(0)));
        }
        return String.format("where(%s)", AbstractGremlinScriptLiteral.generateHas(subject, criteria.getSubValues().get(0)));
    }

    private String generateEmptyScript(@NonNull Criteria criteria) {
        String subject = this.getCriteriaSubject(criteria);
        String has = AbstractGremlinScriptLiteral.generateHas(subject, (Object)true);
        return String.format("where(%s)", has);
    }

    private String generateSingleScript(@NonNull Criteria criteria) {
        CriteriaType type = criteria.getType();
        String subject = this.getCriteriaSubject(criteria);
        long milliSeconds = GremlinUtils.timeToMilliSeconds(criteria.getSubValues().get(0));
        String values = String.format("values('%s')", subject);
        String query = String.format(CriteriaType.criteriaTypeToGremlin(type), milliSeconds);
        String content = String.join((CharSequence)".", values, query);
        return String.format("where(%s)", content);
    }

    private String generateDoubleScript(Criteria criteria) {
        CriteriaType type = criteria.getType();
        String subject = this.getCriteriaSubject(criteria);
        long start = GremlinUtils.toPrimitiveLong(criteria.getSubValues().get(0));
        long end = GremlinUtils.toPrimitiveLong(criteria.getSubValues().get(1));
        String values = String.format("values('%s')", subject);
        String query = String.format(CriteriaType.criteriaTypeToGremlin(type), start, end);
        String content = String.join((CharSequence)".", values, query);
        return String.format("where(%s)", content);
    }

    private String generateCombinedScript(@NonNull String left, @NonNull String right, CriteriaType type) {
        String operation = CriteriaType.criteriaTypeToGremlin(type);
        String content = String.join((CharSequence)".", left, operation, right);
        return String.format("where(%s)", content);
    }

    private String generateScriptTraversal(@NonNull Criteria criteria) {
        CriteriaType type = criteria.getType();
        switch (type) {
            case IS_EQUAL: {
                return this.generateIsEqual(criteria);
            }
            case AND: 
            case OR: {
                String left = this.generateScriptTraversal(criteria.getSubCriteria().get(0));
                String right = this.generateScriptTraversal(criteria.getSubCriteria().get(1));
                return this.generateCombinedScript(left, right, type);
            }
            case AFTER: 
            case BEFORE: {
                return this.generateSingleScript(criteria);
            }
            case BETWEEN: {
                return this.generateDoubleScript(criteria);
            }
            case EXISTS: {
                return this.generateEmptyScript(criteria);
            }
        }
        throw new UnsupportedOperationException("unsupported Criteria type");
    }

    private List<String> generateScript(@NonNull GremlinQuery query) {
        Criteria criteria = query.getCriteria();
        ArrayList<String> scriptList = new ArrayList<String>();
        scriptList.add("g");
        if (this.source instanceof GremlinSourceVertex) {
            scriptList.add("V()");
        } else if (this.source instanceof GremlinSourceEdge) {
            scriptList.add("E()");
        } else {
            throw new UnsupportedOperationException("Cannot generate script from graph entity");
        }
        scriptList.add(AbstractGremlinScriptLiteral.generateHasLabel(this.source.getLabel()));
        scriptList.add(this.generateScriptTraversal(criteria));
        return scriptList;
    }

    @Override
    public List<String> generate(@NonNull GremlinQuery query) {
        ArrayList<String> scriptList = new ArrayList<String>(this.generateScript(query));
        return Collections.singletonList(String.join((CharSequence)".", scriptList));
    }
}

