/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.spring.data.gremlin.repository.support;

import com.microsoft.spring.data.gremlin.query.GremlinOperations;
import com.microsoft.spring.data.gremlin.query.query.GremlinQueryMethod;
import com.microsoft.spring.data.gremlin.query.query.PartTreeGremlinQuery;
import com.microsoft.spring.data.gremlin.repository.support.GremlinEntityInformation;
import com.microsoft.spring.data.gremlin.repository.support.SimpleGremlinRepository;
import java.lang.reflect.Method;
import java.util.Optional;
import org.springframework.context.ApplicationContext;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.repository.core.EntityInformation;
import org.springframework.data.repository.core.NamedQueries;
import org.springframework.data.repository.core.RepositoryInformation;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.core.support.RepositoryFactorySupport;
import org.springframework.data.repository.query.QueryLookupStrategy;
import org.springframework.data.repository.query.QueryMethodEvaluationContextProvider;
import org.springframework.data.repository.query.RepositoryQuery;
import org.springframework.lang.NonNull;
import org.springframework.util.Assert;

public class GremlinRepositoryFactory
extends RepositoryFactorySupport {
    private final ApplicationContext context;
    private final GremlinOperations operations;

    public GremlinRepositoryFactory(@NonNull GremlinOperations operations, ApplicationContext context) {
        this.operations = operations;
        this.context = context;
    }

    protected Class<?> getRepositoryBaseClass(RepositoryMetadata metadata) {
        return SimpleGremlinRepository.class;
    }

    protected Object getTargetRepository(RepositoryInformation information) {
        EntityInformation entityInfo = this.getEntityInformation(information.getDomainType());
        return this.getTargetRepositoryViaReflection(information, new Object[]{entityInfo, this.context});
    }

    public <T, ID> EntityInformation<T, ID> getEntityInformation(Class<T> domainClass) {
        return new GremlinEntityInformation(domainClass);
    }

    protected Optional<QueryLookupStrategy> getQueryLookupStrategy(QueryLookupStrategy.Key key, QueryMethodEvaluationContextProvider provider) {
        return Optional.of(new GremlinQueryLookupStrategy(this.operations));
    }

    private static class GremlinQueryLookupStrategy
    implements QueryLookupStrategy {
        private final GremlinOperations operations;

        public GremlinQueryLookupStrategy(@NonNull GremlinOperations operations) {
            this.operations = operations;
        }

        public RepositoryQuery resolveQuery(@NonNull Method method, RepositoryMetadata metadata, ProjectionFactory factory, NamedQueries namedQueries) {
            GremlinQueryMethod queryMethod = new GremlinQueryMethod(method, metadata, factory);
            Assert.notNull((Object)((Object)queryMethod), (String)"queryMethod should not be null");
            Assert.notNull((Object)this.operations, (String)"operations should not be null");
            return new PartTreeGremlinQuery(queryMethod, this.operations);
        }
    }
}

