/*
 * Decompiled with CFR 0.152.
 */
package com.miguelangeljulvez.easyredsys.server.ws.literal;

import com.miguelangeljulvez.easyredsys.client.AppConfig;
import com.miguelangeljulvez.easyredsys.client.OperationException;
import com.miguelangeljulvez.easyredsys.client.core.Notification;
import com.miguelangeljulvez.easyredsys.client.util.EasyredsysUtil;
import com.miguelangeljulvez.easyredsys.client.util.ResponseCodes;
import com.miguelangeljulvez.easyredsys.server.core.MessageOrderSOAPRequest;
import com.miguelangeljulvez.easyredsys.server.core.MessageOrderSOAPResponse;
import com.miguelangeljulvez.easyredsys.server.core.OrderSOAP;
import com.miguelangeljulvez.easyredsys.server.util.SecurityUtil;
import com.miguelangeljulvez.easyredsys.server.util.XMLSOAPUtil;
import com.miguelangeljulvez.easyredsys.server.ws.literal.InotificacionSIS;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jws.WebService;
import javax.servlet.http.HttpServletRequest;
import org.apache.axis.MessageContext;
import org.apache.axis.transport.http.HTTPConstants;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;

@WebService(serviceName="InotificacionSIS", endpointInterface="com.miguelangeljulvez.easyredsys.server.ws.literal.InotificacionSIS")
public class InotificacionSISImpl
implements InotificacionSIS {
    protected AppConfig appConfig;
    private static final Logger _log = Logger.getLogger(InotificacionSISImpl.class.getName());

    @Override
    public String notificacion(String datoEntrada) {
        _log.log(Level.INFO, "Notificaci\u00f3n del banco recibida");
        _log.log(Level.FINEST, "Notificaci\u00f3n recibida: " + datoEntrada);
        String remoteAddr = this.getRemoteAddr();
        if (!SecurityUtil.isValidIp(remoteAddr)) {
            _log.log(Level.WARNING, "SecurityException - Acceso a la url de notificaci\u00f3n desde ips no autorizadas: " + remoteAddr);
            throw new SecurityException("Acceso a la url de notificaci\u00f3n desde ips no autorizadas");
        }
        if (this.getAppConfig() == null) {
            _log.log(Level.WARNING, "El bean con los datos de la pasarela no se ha inyectado. Debes crear una clase que implemente la interface AppConfig");
            _log.log(Level.WARNING, "Usando password por defecto de la pasarela de test: 'sq7HjrUOBfKmC576ILgskD5srU870gJ7'");
        }
        String clave = EasyredsysUtil.getSecretyKey((AppConfig)this.getAppConfig());
        MessageOrderSOAPRequest messageOrderSOAPRequest = new MessageOrderSOAPRequest(datoEntrada, clave);
        _log.log(Level.FINEST, "Notificaci\u00f3n recibida: " + (Object)((Object)messageOrderSOAPRequest.getNotificationSOAP()));
        if (!messageOrderSOAPRequest.isValid()) {
            _log.log(Level.WARNING, "SecurityException - La firma recibida no es correcta: " + messageOrderSOAPRequest.getSignature());
            throw new SecurityException("La firma recibida no es correcta");
        }
        _log.info("Notificaci\u00f3n v\u00e1lida recibida para la order " + messageOrderSOAPRequest.getNotificationSOAP().getDs_Order());
        if (!ResponseCodes.isSuccessResponse((String)messageOrderSOAPRequest.getNotificationSOAP().getDs_Response())) {
            _log.log(Level.WARNING, "OperationException: Response code de error");
            throw new SecurityException(ResponseCodes.getErrorResponseMessage((String)messageOrderSOAPRequest.getNotificationSOAP().getDs_Response()));
        }
        boolean error = false;
        if (this.getAppConfig() == null) {
            _log.log(Level.WARNING, "El bean con los datos de la pasarela no se ha inyectado. Debes crear una clase que implemente la interface AppConfig");
            _log.log(Level.WARNING, "No hay nada que hacer con la notificaci\u00f3n recibida");
            error = true;
        } else {
            try {
                this.getAppConfig().saveNotification((Notification)messageOrderSOAPRequest.getNotificationSOAP());
            }
            catch (OperationException e) {
                _log.log(Level.SEVERE, e.getMessage(), e);
                error = true;
            }
        }
        OrderSOAP orderSOAP = new OrderSOAP(messageOrderSOAPRequest.getNotificationSOAP().getDs_Order());
        orderSOAP.setDs_version("0.0");
        if (error) {
            orderSOAP.setDs_response_merchant("KO");
        } else {
            orderSOAP.setDs_response_merchant("OK");
        }
        MessageOrderSOAPResponse messageOrderSOAPResponse = new MessageOrderSOAPResponse(orderSOAP, clave);
        String val_xml = XMLSOAPUtil.toRedsysXML(messageOrderSOAPResponse);
        _log.log(Level.FINEST, "Respuesta a la notificaci\u00f3n: " + val_xml);
        return val_xml;
    }

    private String getRemoteAddr() {
        HttpServletRequest servletReq;
        String remoteAddr = "";
        MessageContext context = MessageContext.getCurrentContext();
        if (context != null && context.containsProperty(HTTPConstants.MC_HTTP_SERVLETREQUEST) && (servletReq = (HttpServletRequest)context.getProperty(HTTPConstants.MC_HTTP_SERVLETREQUEST)) != null) {
            remoteAddr = servletReq.getRemoteAddr();
        }
        if (context == null) {
            return "127.0.0.1";
        }
        return remoteAddr;
    }

    protected AppConfig getAppConfig() {
        if (this.appConfig == null) {
            Package[] packages;
            for (Package packageP : packages = Package.getPackages()) {
                Reflections reflections = new Reflections(packageP.getName(), new Scanner[0]);
                Set subTypesOf = reflections.getSubTypesOf(AppConfig.class);
                if (subTypesOf.size() > 1) {
                    _log.log(Level.SEVERE, "Mas de una clase en el classpath implementa AppConfig. Revisa tu aplicaci\u00f3n");
                    return null;
                }
                if (subTypesOf.size() != 1) continue;
                try {
                    this.appConfig = (AppConfig)((Class)subTypesOf.iterator().next()).newInstance();
                    return this.appConfig;
                }
                catch (IllegalAccessException | InstantiationException e) {
                    _log.log(Level.SEVERE, "No se ha podido instanciar la clase que implementa AppConfig");
                }
            }
        }
        return this.appConfig;
    }

    protected void setAppConfig(AppConfig appConfig) {
        this.appConfig = appConfig;
    }
}

