/*
 * Decompiled with CFR 0.152.
 */
package com.miguelangeljulvez.easyredsys.server.ws.rest;

import com.miguelangeljulvez.easyredsys.client.AppConfig;
import com.miguelangeljulvez.easyredsys.client.OperationException;
import com.miguelangeljulvez.easyredsys.client.core.MessageOrderCESResponse;
import com.miguelangeljulvez.easyredsys.client.core.Notification;
import com.miguelangeljulvez.easyredsys.client.util.EasyredsysUtil;
import com.miguelangeljulvez.easyredsys.client.util.ResponseCodes;
import com.miguelangeljulvez.easyredsys.server.util.SecurityUtil;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.FormParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;

@Path(value="/InotificacionSIS")
public class InotificacionSISRest {
    AppConfig appConfig;
    private static final Logger _log = Logger.getLogger(InotificacionSISRest.class.getName());

    @POST
    public Response notificar(@FormParam(value="Ds_SignatureVersion") String ds_SignatureVersion, @FormParam(value="Ds_MerchantParameters") String ds_MerchantParameters, @FormParam(value="Ds_Signature") String ds_Signature, @Context HttpServletRequest request) {
        _log.log(Level.INFO, "Notificaci\u00f3n del banco recibida");
        _log.log(Level.FINEST, "ds_SignatureVersion: " + ds_SignatureVersion);
        _log.log(Level.FINEST, "ds_MerchantParameters: " + ds_MerchantParameters);
        _log.log(Level.FINEST, "ds_Signature: " + ds_Signature);
        if (!SecurityUtil.isValidIp(request.getRemoteAddr())) {
            _log.log(Level.WARNING, "La notificaci\u00f3n se ha recibido desde una IP no permitida");
            return Response.status((int)400).build();
        }
        if (this.getAppConfig() == null) {
            _log.log(Level.WARNING, "El bean con los datos de la pasarela no se ha inyectado. Debes crear una clase que implemente la interface AppConfig");
            _log.log(Level.WARNING, "Usando password por defecto de la pasarela de test: 'sq7HjrUOBfKmC576ILgskD5srU870gJ7'");
        }
        String clave = EasyredsysUtil.getSecretyKey((AppConfig)this.getAppConfig());
        MessageOrderCESResponse messageOrderCESResponse = new MessageOrderCESResponse(ds_SignatureVersion, ds_Signature, ds_MerchantParameters, clave);
        _log.log(Level.FINEST, "Notificaci\u00f3n recibida: " + messageOrderCESResponse.getOperationCES());
        if (!messageOrderCESResponse.isValid()) {
            _log.log(Level.WARNING, "Notificaci\u00f3n para el pedido " + messageOrderCESResponse.getOperationCES().getDs_Order() + " recibida err\u00f3neamente. La firma no es v\u00e1lida");
            return Response.status((int)400).build();
        }
        _log.info("Notificaci\u00f3n v\u00e1lida recibida para la order: " + messageOrderCESResponse.getOperationCES().getDs_Order());
        if (!ResponseCodes.isSuccessResponse((String)messageOrderCESResponse.getOperationCES().getDs_Response())) {
            _log.log(Level.WARNING, "OperationException: Response code de error: " + messageOrderCESResponse.getOperationCES().getDs_Response());
            throw new SecurityException(ResponseCodes.getErrorResponseMessage((String)messageOrderCESResponse.getOperationCES().getDs_Response()));
        }
        boolean error = false;
        if (this.getAppConfig() == null) {
            _log.log(Level.WARNING, "El bean con los datos de la pasarela no se ha inyectado. Debes crear una clase que implemente la interface AppConfig");
            _log.log(Level.WARNING, "No hay nada que hacer con la notificaci\u00f3n recibida");
            error = true;
        } else {
            try {
                this.getAppConfig().saveNotification((Notification)messageOrderCESResponse.getOperationCES());
            }
            catch (OperationException e) {
                _log.log(Level.SEVERE, e.getMessage(), e);
                error = true;
            }
        }
        if (error) {
            return Response.status((int)400).build();
        }
        return Response.status((int)200).build();
    }

    protected AppConfig getAppConfig() {
        if (this.appConfig == null) {
            Package[] packages;
            for (Package packageP : packages = Package.getPackages()) {
                Reflections reflections = new Reflections(packageP.getName(), new Scanner[0]);
                Set subTypesOf = reflections.getSubTypesOf(AppConfig.class);
                if (subTypesOf.size() > 1) {
                    _log.log(Level.SEVERE, "Mas de una clase en el classpath implementa AppConfig. Revisa tu aplicaci\u00f3n");
                    return null;
                }
                if (subTypesOf.size() != 1) continue;
                try {
                    this.appConfig = (AppConfig)((Class)subTypesOf.iterator().next()).newInstance();
                    return this.appConfig;
                }
                catch (IllegalAccessException | InstantiationException e) {
                    _log.log(Level.SEVERE, "No se ha podido instanciar la clase que implementa AppConfig");
                }
            }
        }
        return this.appConfig;
    }

    protected void setAppConfig(AppConfig appConfig) {
        this.appConfig = appConfig;
    }
}

