/*
 * Decompiled with CFR 0.152.
 */
package com.mikepenz.iconics;

import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.support.annotation.ColorInt;
import android.support.annotation.ColorRes;
import android.support.annotation.DimenRes;
import android.support.annotation.Dimension;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.content.ContextCompat;
import android.text.TextPaint;
import android.util.Log;
import android.view.View;
import com.mikepenz.iconics.Iconics;
import com.mikepenz.iconics.typeface.IIcon;
import com.mikepenz.iconics.typeface.ITypeface;
import com.mikepenz.iconics.utils.Utils;

public class IconicsDrawable
extends Drawable {
    @Dimension(unit=0)
    public static final int TOOLBAR_ICON_SIZE = 24;
    @Dimension(unit=0)
    public static final int TOOLBAR_ICON_PADDING = 1;
    private Context mContext;
    private int mSizeX = -1;
    private int mSizeY = -1;
    private boolean mRespectFontBounds = false;
    private ColorStateList mIconColor;
    private Paint mIconPaint;
    private int mBackgroundContourColor;
    private int mContourColor;
    private Paint mContourPaint;
    private int mBackgroundColor;
    private Paint mBackgroundPaint;
    private Paint mBackgroundContourPaint;
    private int mRoundedCornerRx = -1;
    private int mRoundedCornerRy = -1;
    private Rect mPaddingBounds;
    private RectF mPathBounds;
    private Path mPath;
    private int mIconPadding;
    private int mContourWidth;
    private int mBackgroundContourWidth;
    private int mIconOffsetX = 0;
    private int mIconOffsetY = 0;
    private int mAlpha = 255;
    private boolean mDrawContour;
    private boolean mDrawBackgroundContour;
    private float mShadowRadius = 0.0f;
    private float mShadowDx = 0.0f;
    private float mShadowDy = 0.0f;
    private int mShadowColor = 0;
    private IIcon mIcon;
    private String mPlainIcon;
    private ColorStateList mTint;
    private PorterDuff.Mode mTintMode = PorterDuff.Mode.SRC_IN;
    private ColorFilter mTintFilter;
    private ColorFilter mColorFilter;

    public IconicsDrawable(Context context) {
        this.mContext = context.getApplicationContext();
        this.prepare();
        this.icon(Character.valueOf(' '));
    }

    public IconicsDrawable(Context context, Character icon) {
        this.mContext = context.getApplicationContext();
        this.prepare();
        this.icon(icon);
    }

    public IconicsDrawable(Context context, String icon) {
        this.mContext = context.getApplicationContext();
        this.prepare();
        try {
            ITypeface font = Iconics.findFont(context, icon.substring(0, 3));
            icon = icon.replace("-", "_");
            this.icon(font.getIcon(icon));
        }
        catch (Exception ex) {
            Log.e((String)Iconics.TAG, (String)("Wrong icon name: " + icon));
        }
    }

    public IconicsDrawable(Context context, IIcon icon) {
        this.mContext = context.getApplicationContext();
        this.prepare();
        this.icon(icon);
    }

    protected IconicsDrawable(Context context, ITypeface typeface, IIcon icon) {
        this.mContext = context.getApplicationContext();
        this.prepare();
        this.icon(typeface, icon);
    }

    public int getColor() {
        return this.mIconColor.getDefaultColor();
    }

    public ColorStateList getColorList() {
        return this.mIconColor;
    }

    public int getContourColor() {
        return this.mContourColor;
    }

    public int getBackgroundColor() {
        return this.mBackgroundColor;
    }

    public int getBackgroundContourColor() {
        return this.mBackgroundContourColor;
    }

    public IIcon getIcon() {
        return this.mIcon;
    }

    public String getPlainIcon() {
        return this.mPlainIcon;
    }

    public int getCompatAlpha() {
        return this.mAlpha;
    }

    public Bitmap toBitmap() {
        if (this.mSizeX == -1 || this.mSizeY == -1) {
            this.actionBar();
        }
        Bitmap bitmap = Bitmap.createBitmap((int)this.getIntrinsicWidth(), (int)this.getIntrinsicHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        this.style(Paint.Style.FILL);
        Canvas canvas = new Canvas(bitmap);
        this.setBounds(0, 0, canvas.getWidth(), canvas.getHeight());
        this.draw(canvas);
        return bitmap;
    }

    public IconicsDrawable clone() {
        IconicsDrawable iconicsDrawable = new IconicsDrawable(this.mContext).paddingPx(this.mIconPadding).roundedCornersRxPx(this.mRoundedCornerRx).roundedCornersRyPx(this.mRoundedCornerRy).sizePxX(this.mSizeX).sizePxY(this.mSizeY).iconOffsetXPx(this.mIconOffsetX).iconOffsetYPx(this.mIconOffsetY).contourColor(this.mContourColor).contourWidthPx(this.mContourWidth).shadowPx(this.mShadowRadius, this.mShadowDx, this.mShadowDy, this.mShadowColor).backgroundColor(this.mBackgroundColor).backgroundContourColor(this.mBackgroundContourColor).backgroundContourWidthPx(this.mBackgroundContourWidth).color(this.mIconColor).alpha(this.mAlpha).drawContour(this.mDrawContour).drawBackgroundContour(this.mDrawBackgroundContour).typeface(this.mIconPaint.getTypeface());
        if (this.mIcon != null) {
            iconicsDrawable.icon(this.mIcon);
        } else if (this.mPlainIcon != null) {
            iconicsDrawable.iconText(this.mPlainIcon);
        }
        return iconicsDrawable;
    }

    public IconicsDrawable icon(String icon) {
        try {
            ITypeface font = Iconics.findFont(this.mContext, icon.substring(0, 3));
            icon = icon.replace("-", "_");
            this.icon(font.getIcon(icon));
        }
        catch (Exception ex) {
            Log.e((String)Iconics.TAG, (String)("Wrong icon name: " + icon));
        }
        return this;
    }

    public IconicsDrawable icon(Character icon) {
        return this.iconText(icon.toString(), null);
    }

    public IconicsDrawable icon(Character icon, @Nullable Typeface typeface) {
        return this.iconText(icon.toString(), typeface);
    }

    public IconicsDrawable iconText(String icon) {
        return this.iconText(icon, null);
    }

    public IconicsDrawable iconText(String icon, @Nullable Typeface typeface) {
        this.mPlainIcon = icon;
        this.mIcon = null;
        this.mIconPaint.setTypeface(typeface == null ? Typeface.DEFAULT : typeface);
        this.invalidateSelf();
        return this;
    }

    public IconicsDrawable icon(IIcon icon) {
        this.mIcon = icon;
        this.mPlainIcon = null;
        ITypeface typeface = icon.getTypeface();
        this.mIconPaint.setTypeface(typeface.getTypeface(this.mContext));
        this.invalidateSelf();
        return this;
    }

    protected IconicsDrawable icon(ITypeface typeface, IIcon icon) {
        this.mIcon = icon;
        this.mIconPaint.setTypeface(typeface.getTypeface(this.mContext));
        this.invalidateSelf();
        return this;
    }

    public IconicsDrawable respectFontBounds(boolean respectBounds) {
        this.mRespectFontBounds = respectBounds;
        this.invalidateSelf();
        return this;
    }

    public IconicsDrawable color(@ColorInt int color) {
        this.mIconColor = ColorStateList.valueOf((int)color);
        this.updateIconColor();
        return this;
    }

    public IconicsDrawable colorRes(@ColorRes int colorRes) {
        return this.color(ContextCompat.getColor((Context)this.mContext, (int)colorRes));
    }

    public IconicsDrawable colorListRes(@ColorRes int colorRes) {
        return this.color(ContextCompat.getColorStateList((Context)this.mContext, (int)colorRes));
    }

    public IconicsDrawable color(ColorStateList colors) {
        if (colors != null) {
            this.mIconColor = colors;
            this.updateIconColor();
        }
        return this;
    }

    public IconicsDrawable iconOffsetXRes(@DimenRes int iconOffsetXRes) {
        return this.iconOffsetXPx(this.mContext.getResources().getDimensionPixelSize(iconOffsetXRes));
    }

    public IconicsDrawable iconOffsetXDp(@Dimension(unit=0) int iconOffsetXDp) {
        return this.iconOffsetXPx(Utils.convertDpToPx(this.mContext, iconOffsetXDp));
    }

    public IconicsDrawable iconOffsetXPx(@Dimension(unit=1) int iconOffsetX) {
        this.mIconOffsetX = iconOffsetX;
        this.invalidateSelf();
        return this;
    }

    public IconicsDrawable iconOffsetYRes(@DimenRes int iconOffsetYRes) {
        return this.iconOffsetYPx(this.mContext.getResources().getDimensionPixelSize(iconOffsetYRes));
    }

    public IconicsDrawable iconOffsetYDp(@Dimension(unit=0) int iconOffsetYDp) {
        return this.iconOffsetYPx(Utils.convertDpToPx(this.mContext, iconOffsetYDp));
    }

    public IconicsDrawable iconOffsetYPx(@Dimension(unit=1) int iconOffsetY) {
        this.mIconOffsetY = iconOffsetY;
        this.invalidateSelf();
        return this;
    }

    public IconicsDrawable paddingRes(@DimenRes int dimenRes) {
        return this.paddingPx(this.mContext.getResources().getDimensionPixelSize(dimenRes));
    }

    public IconicsDrawable paddingDp(@Dimension(unit=0) int iconPadding) {
        return this.paddingPx(Utils.convertDpToPx(this.mContext, iconPadding));
    }

    public IconicsDrawable paddingPx(@Dimension(unit=1) int iconPadding) {
        if (this.mIconPadding != iconPadding) {
            this.mIconPadding = iconPadding;
            if (this.mDrawContour) {
                this.mIconPadding += this.mContourWidth;
            }
            if (this.mDrawBackgroundContour) {
                this.mIconPadding += this.mBackgroundContourWidth;
            }
            this.invalidateSelf();
        }
        return this;
    }

    public IconicsDrawable actionBar() {
        this.sizeDp(24);
        this.paddingDp(1);
        return this;
    }

    public IconicsDrawable sizeRes(@DimenRes int dimenRes) {
        return this.sizePx(this.mContext.getResources().getDimensionPixelSize(dimenRes));
    }

    public IconicsDrawable sizeDp(@Dimension(unit=0) int size) {
        return this.sizePx(Utils.convertDpToPx(this.mContext, size));
    }

    public IconicsDrawable sizePx(@Dimension(unit=1) int size) {
        this.mSizeX = this.mSizeY = size;
        this.setBounds(0, 0, this.mSizeX, this.mSizeY);
        this.invalidateSelf();
        return this;
    }

    public IconicsDrawable sizeResX(@DimenRes int dimenResX) {
        return this.sizePxX(this.mContext.getResources().getDimensionPixelSize(dimenResX));
    }

    public IconicsDrawable sizeDpX(@Dimension(unit=0) int sizeX) {
        return this.sizePxX(Utils.convertDpToPx(this.mContext, sizeX));
    }

    public IconicsDrawable sizePxX(@Dimension(unit=1) int sizeX) {
        this.mSizeX = sizeX;
        this.setBounds(0, 0, this.mSizeX, this.mSizeY);
        this.invalidateSelf();
        return this;
    }

    public IconicsDrawable sizeResY(@DimenRes int dimenResY) {
        return this.sizePxY(this.mContext.getResources().getDimensionPixelSize(dimenResY));
    }

    public IconicsDrawable sizeDpY(@Dimension(unit=0) int sizeY) {
        return this.sizePxY(Utils.convertDpToPx(this.mContext, sizeY));
    }

    public IconicsDrawable sizePxY(@Dimension(unit=1) int sizeY) {
        this.mSizeY = sizeY;
        this.setBounds(0, 0, this.mSizeX, this.mSizeY);
        this.invalidateSelf();
        return this;
    }

    public IconicsDrawable backgroundContourColorRes(@ColorRes int backgroundContourColorRes) {
        return this.backgroundContourColor(ContextCompat.getColor((Context)this.mContext, (int)backgroundContourColorRes));
    }

    public IconicsDrawable backgroundContourColor(@ColorInt int backgroundContourColor) {
        int red = Color.red((int)backgroundContourColor);
        int green = Color.green((int)backgroundContourColor);
        int blue = Color.blue((int)backgroundContourColor);
        this.mBackgroundContourPaint.setColor(Color.rgb((int)red, (int)green, (int)blue));
        this.mBackgroundContourPaint.setAlpha(Color.alpha((int)backgroundContourColor));
        this.mBackgroundContourColor = backgroundContourColor;
        this.invalidateSelf();
        return this;
    }

    public IconicsDrawable contourColorRes(@ColorRes int contourColorRes) {
        return this.contourColor(ContextCompat.getColor((Context)this.mContext, (int)contourColorRes));
    }

    public IconicsDrawable contourColor(@ColorInt int contourColor) {
        int red = Color.red((int)contourColor);
        int green = Color.green((int)contourColor);
        int blue = Color.blue((int)contourColor);
        this.mContourPaint.setColor(Color.rgb((int)red, (int)green, (int)blue));
        this.mContourPaint.setAlpha(Color.alpha((int)contourColor));
        this.mContourColor = contourColor;
        this.invalidateSelf();
        return this;
    }

    public IconicsDrawable backgroundColorRes(@ColorRes int backgroundColorRes) {
        return this.backgroundColor(ContextCompat.getColor((Context)this.mContext, (int)backgroundColorRes));
    }

    public IconicsDrawable backgroundColor(@ColorInt int backgroundColor) {
        this.mBackgroundPaint.setColor(backgroundColor);
        this.mBackgroundColor = backgroundColor;
        if (this.mRoundedCornerRx == -1) {
            this.mRoundedCornerRx = 0;
        }
        if (this.mRoundedCornerRy == -1) {
            this.mRoundedCornerRy = 0;
        }
        this.invalidateSelf();
        return this;
    }

    public IconicsDrawable roundedCornersRxRes(@DimenRes int roundedCornerRxRes) {
        return this.roundedCornersRxPx(this.mContext.getResources().getDimensionPixelSize(roundedCornerRxRes));
    }

    public IconicsDrawable roundedCornersRxDp(@Dimension(unit=0) int roundedCornerRxDp) {
        return this.roundedCornersRxPx(Utils.convertDpToPx(this.mContext, roundedCornerRxDp));
    }

    public IconicsDrawable roundedCornersRxPx(@Dimension(unit=1) int roundedCornerRxPx) {
        this.mRoundedCornerRx = roundedCornerRxPx;
        this.invalidateSelf();
        return this;
    }

    public IconicsDrawable roundedCornersRyRes(@DimenRes int roundedCornerRyRes) {
        return this.roundedCornersRyPx(this.mContext.getResources().getDimensionPixelSize(roundedCornerRyRes));
    }

    public IconicsDrawable roundedCornersRyDp(@Dimension(unit=0) int roundedCornerRyDp) {
        return this.roundedCornersRyPx(Utils.convertDpToPx(this.mContext, roundedCornerRyDp));
    }

    public IconicsDrawable roundedCornersRyPx(@Dimension(unit=1) int roundedCornerRyPx) {
        this.mRoundedCornerRy = roundedCornerRyPx;
        this.invalidateSelf();
        return this;
    }

    public IconicsDrawable roundedCornersRes(@DimenRes int roundedCornerRes) {
        return this.roundedCornersPx(this.mContext.getResources().getDimensionPixelSize(roundedCornerRes));
    }

    public IconicsDrawable roundedCornersDp(@Dimension(unit=0) int roundedCornerDp) {
        return this.roundedCornersPx(Utils.convertDpToPx(this.mContext, roundedCornerDp));
    }

    public IconicsDrawable roundedCornersPx(@Dimension(unit=1) int roundedCornerPx) {
        this.mRoundedCornerRx = this.mRoundedCornerRy = roundedCornerPx;
        this.invalidateSelf();
        return this;
    }

    public IconicsDrawable contourWidthRes(@DimenRes int contourWidthRes) {
        return this.contourWidthPx(this.mContext.getResources().getDimensionPixelSize(contourWidthRes));
    }

    public IconicsDrawable contourWidthDp(@Dimension(unit=0) int contourWidthDp) {
        return this.contourWidthPx(Utils.convertDpToPx(this.mContext, contourWidthDp));
    }

    public IconicsDrawable contourWidthPx(@Dimension(unit=1) int contourWidth) {
        this.mContourWidth = contourWidth;
        this.mContourPaint.setStrokeWidth((float)this.mContourWidth);
        this.drawContour(true);
        this.invalidateSelf();
        return this;
    }

    public IconicsDrawable enableShadowSupport(View view) {
        view.setLayerType(1, null);
        return this;
    }

    public IconicsDrawable shadowRes(@DimenRes int radiusRes, @DimenRes int dxRes, @DimenRes int dyRes, @ColorRes int colorRes) {
        return this.shadowPx(this.mContext.getResources().getDimensionPixelSize(radiusRes), this.mContext.getResources().getDimensionPixelSize(dxRes), this.mContext.getResources().getDimensionPixelSize(dyRes), ContextCompat.getColor((Context)this.mContext, (int)colorRes));
    }

    public IconicsDrawable shadowDp(@Dimension(unit=0) float radiusDp, @Dimension(unit=0) float dxDp, @Dimension(unit=0) float dyDp, @ColorInt int color) {
        return this.shadowPx(Utils.convertDpToPx(this.mContext, radiusDp), Utils.convertDpToPx(this.mContext, dxDp), Utils.convertDpToPx(this.mContext, dyDp), color);
    }

    public IconicsDrawable shadowPx(@Dimension(unit=1) float radius, @Dimension(unit=1) float dx, @Dimension(unit=1) float dy, @ColorInt int color) {
        this.mShadowRadius = radius;
        this.mShadowDx = dx;
        this.mShadowDy = dy;
        this.mShadowColor = color;
        this.mIconPaint.setShadowLayer(radius, dx, dy, color);
        this.invalidateSelf();
        return this;
    }

    public IconicsDrawable backgroundContourWidthRes(@DimenRes int backgroundContourWidthRes) {
        return this.backgroundContourWidthPx(this.mContext.getResources().getDimensionPixelSize(backgroundContourWidthRes));
    }

    public IconicsDrawable backgroundContourWidthDp(@Dimension(unit=0) int backgroundContourWidthDp) {
        return this.backgroundContourWidthPx(Utils.convertDpToPx(this.mContext, backgroundContourWidthDp));
    }

    public IconicsDrawable backgroundContourWidthPx(@Dimension(unit=1) int backgroundContourWidth) {
        this.mBackgroundContourWidth = backgroundContourWidth;
        this.mBackgroundContourPaint.setStrokeWidth((float)this.mBackgroundContourWidth);
        this.drawBackgroundContour(true);
        this.invalidateSelf();
        return this;
    }

    public IconicsDrawable drawContour(boolean drawContour) {
        if (this.mDrawContour != drawContour) {
            this.mDrawContour = drawContour;
            this.mIconPadding += (this.mDrawContour ? 1 : -1) * this.mContourWidth;
            this.invalidateSelf();
        }
        return this;
    }

    public IconicsDrawable drawBackgroundContour(boolean drawBackgroundContour) {
        if (this.mDrawBackgroundContour != drawBackgroundContour) {
            this.mDrawBackgroundContour = drawBackgroundContour;
            this.mIconPadding += (this.mDrawBackgroundContour ? 1 : -1) * this.mBackgroundContourWidth * 2;
            this.invalidateSelf();
        }
        return this;
    }

    public IconicsDrawable colorFilter(ColorFilter cf) {
        this.setColorFilter(cf);
        return this;
    }

    public IconicsDrawable alpha(int alpha) {
        this.setAlpha(alpha);
        return this;
    }

    public IconicsDrawable style(Paint.Style style) {
        this.mIconPaint.setStyle(style);
        this.invalidateSelf();
        return this;
    }

    public IconicsDrawable typeface(Typeface typeface) {
        this.mIconPaint.setTypeface(typeface);
        this.invalidateSelf();
        return this;
    }

    public void draw(@NonNull Canvas canvas) {
        if (this.mIcon != null || this.mPlainIcon != null) {
            Rect viewBounds = this.getBounds();
            this.updatePaddingBounds(viewBounds);
            this.updateTextSize(viewBounds);
            this.offsetIcon(viewBounds);
            if (this.mBackgroundPaint != null && this.mRoundedCornerRy > -1 && this.mRoundedCornerRx > -1) {
                if (this.mDrawBackgroundContour && this.mBackgroundContourPaint != null) {
                    float halfContourSize = this.mBackgroundContourWidth / 2;
                    RectF rectF = new RectF(halfContourSize, halfContourSize, (float)viewBounds.width() - halfContourSize, (float)viewBounds.height() - halfContourSize);
                    canvas.drawRoundRect(rectF, (float)this.mRoundedCornerRx, (float)this.mRoundedCornerRy, this.mBackgroundPaint);
                    canvas.drawRoundRect(rectF, (float)this.mRoundedCornerRx, (float)this.mRoundedCornerRy, this.mBackgroundContourPaint);
                } else {
                    RectF rectF = new RectF(0.0f, 0.0f, (float)viewBounds.width(), (float)viewBounds.height());
                    canvas.drawRoundRect(rectF, (float)this.mRoundedCornerRx, (float)this.mRoundedCornerRy, this.mBackgroundPaint);
                }
            }
            try {
                this.mPath.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.mDrawContour) {
                canvas.drawPath(this.mPath, this.mContourPaint);
            }
            this.mIconPaint.setAlpha(this.mAlpha);
            this.mIconPaint.setColorFilter(this.mColorFilter == null ? this.mTintFilter : this.mColorFilter);
            canvas.drawPath(this.mPath, this.mIconPaint);
        }
    }

    public void setTint(int tintColor) {
        this.setTintList(ColorStateList.valueOf((int)tintColor));
    }

    public void setTintList(ColorStateList tint) {
        this.mTint = tint;
        this.mTintFilter = this.updateTintFilter(tint, this.mTintMode);
        this.invalidateSelf();
    }

    public void setTintMode(@NonNull PorterDuff.Mode tintMode) {
        this.mTintMode = tintMode;
        this.mTintFilter = this.updateTintFilter(this.mTint, tintMode);
        this.invalidateSelf();
    }

    protected void onBoundsChange(Rect bounds) {
        this.offsetIcon(bounds);
        try {
            this.mPath.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.onBoundsChange(bounds);
    }

    public boolean isStateful() {
        return true;
    }

    public boolean setState(@NonNull int[] stateSet) {
        boolean b = super.setState(stateSet);
        return b || this.mIconColor != null && this.mIconColor.isStateful() || this.mColorFilter != null || this.mTintFilter != null;
    }

    public int getOpacity() {
        if (this.mTintFilter != null || this.mIconPaint.getColorFilter() != null) {
            return -3;
        }
        switch (this.getAlpha()) {
            case 255: {
                return -1;
            }
            case 0: {
                return -2;
            }
        }
        return -3;
    }

    protected boolean onStateChange(int[] stateSet) {
        boolean ret = false;
        if (this.mIconColor != null && this.mIconColor.isStateful()) {
            this.updateIconColor();
            ret = true;
        }
        if (this.mTint != null && this.mTintMode != null) {
            this.mTintFilter = this.updateTintFilter(this.mTint, this.mTintMode);
            this.invalidateSelf();
            ret = true;
        }
        return ret;
    }

    public int getIntrinsicWidth() {
        return this.mSizeX;
    }

    public int getIntrinsicHeight() {
        return this.mSizeY;
    }

    public void setAlpha(int alpha) {
        this.mIconPaint.setAlpha(alpha);
        this.mAlpha = alpha;
        this.invalidateSelf();
    }

    public int getAlpha() {
        return this.mAlpha;
    }

    public void setColorFilter(ColorFilter cf) {
        this.mColorFilter = cf;
        this.invalidateSelf();
    }

    public void clearColorFilter() {
        this.mColorFilter = null;
        this.invalidateSelf();
    }

    private void prepare() {
        this.mIconPaint = new TextPaint(1);
        this.mIconPaint.setStyle(Paint.Style.FILL);
        this.mIconPaint.setTextAlign(Paint.Align.CENTER);
        this.mIconPaint.setUnderlineText(false);
        this.mIconPaint.setAntiAlias(true);
        this.mBackgroundPaint = new Paint(1);
        this.mContourPaint = new Paint(1);
        this.mContourPaint.setStyle(Paint.Style.STROKE);
        this.mBackgroundContourPaint = new Paint(1);
        this.mBackgroundContourPaint.setStyle(Paint.Style.STROKE);
        this.mPath = new Path();
        this.mPathBounds = new RectF();
        this.mPaddingBounds = new Rect();
    }

    private void updatePaddingBounds(Rect viewBounds) {
        if (this.mIconPadding >= 0 && this.mIconPadding * 2 <= viewBounds.width() && this.mIconPadding * 2 <= viewBounds.height()) {
            this.mPaddingBounds.set(viewBounds.left + this.mIconPadding, viewBounds.top + this.mIconPadding, viewBounds.right - this.mIconPadding, viewBounds.bottom - this.mIconPadding);
        }
    }

    private void updateTextSize(Rect viewBounds) {
        float textSize = (float)viewBounds.height() * (float)(this.mRespectFontBounds ? 1 : 2);
        this.mIconPaint.setTextSize(textSize);
        String textValue = this.mIcon != null ? String.valueOf(this.mIcon.getCharacter()) : String.valueOf(this.mPlainIcon);
        this.mIconPaint.getTextPath(textValue, 0, textValue.length(), 0.0f, (float)viewBounds.height(), this.mPath);
        this.mPath.computeBounds(this.mPathBounds, true);
        if (!this.mRespectFontBounds) {
            float deltaHeight;
            float deltaWidth = (float)this.mPaddingBounds.width() / this.mPathBounds.width();
            float delta = deltaWidth < (deltaHeight = (float)this.mPaddingBounds.height() / this.mPathBounds.height()) ? deltaWidth : deltaHeight;
            this.mIconPaint.setTextSize(textSize *= delta);
            this.mIconPaint.getTextPath(textValue, 0, textValue.length(), 0.0f, (float)viewBounds.height(), this.mPath);
            this.mPath.computeBounds(this.mPathBounds, true);
        }
    }

    private void offsetIcon(Rect viewBounds) {
        float startX = (float)viewBounds.centerX() - this.mPathBounds.width() / 2.0f;
        float offsetX = startX - this.mPathBounds.left;
        float startY = (float)viewBounds.centerY() - this.mPathBounds.height() / 2.0f;
        float offsetY = startY - this.mPathBounds.top;
        this.mPath.offset(offsetX + (float)this.mIconOffsetX, offsetY + (float)this.mIconOffsetY);
    }

    private void updateIconColor() {
        int alpha;
        int blue;
        int green;
        boolean invalidate = false;
        int color = this.mIconColor.getColorForState(this.getState(), this.mIconColor.getDefaultColor());
        int red = Color.red((int)color);
        int iconColor = Color.rgb((int)red, (int)(green = Color.green((int)color)), (int)(blue = Color.blue((int)color)));
        if (iconColor != this.mIconPaint.getColor()) {
            this.mIconPaint.setColor(iconColor);
            invalidate = true;
        }
        if ((alpha = Color.alpha((int)color)) != 255 && alpha != this.mAlpha) {
            this.setAlpha(alpha);
        } else if (invalidate) {
            this.invalidateSelf();
        }
    }

    private PorterDuffColorFilter updateTintFilter(ColorStateList tint, PorterDuff.Mode tintMode) {
        if (tint == null || tintMode == null) {
            return null;
        }
        int color = tint.getColorForState(this.getState(), 0);
        return new PorterDuffColorFilter(color, tintMode);
    }
}

