/*
 * Decompiled with CFR 0.152.
 */
package com.mikepenz.iconics.utils;

import android.content.Context;
import android.text.Editable;
import android.text.ParcelableSpan;
import android.text.Spannable;
import android.text.SpannableStringBuilder;
import android.text.Spanned;
import android.text.style.CharacterStyle;
import android.util.Log;
import com.mikepenz.iconics.Iconics;
import com.mikepenz.iconics.typeface.IIcon;
import com.mikepenz.iconics.typeface.ITypeface;
import com.mikepenz.iconics.utils.IconicsTypefaceSpan;
import com.mikepenz.iconics.utils.StyleContainer;
import com.mikepenz.iconics.utils.TextStyleContainer;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;

public class IconicsUtils {
    public static char ICON_START = (char)123;
    public static char ICON_END = (char)125;

    public static LinkedList<StyleContainer> findIconsFromEditable(Editable editable, HashMap<String, ITypeface> fonts) {
        LinkedList<StyleContainer> styleContainers = new LinkedList<StyleContainer>();
        LinkedList<StyleContainer> existingSpans = new LinkedList<StyleContainer>();
        for (ParcelableSpan parcelableSpan : (ParcelableSpan[])editable.getSpans(0, editable.length(), ParcelableSpan.class)) {
            existingSpans.add(new StyleContainer(editable.getSpanStart((Object)parcelableSpan), editable.getSpanEnd((Object)parcelableSpan), parcelableSpan, editable.getSpanFlags((Object)parcelableSpan)));
        }
        for (ParcelableSpan parcelableSpan : (CharacterStyle[])editable.getSpans(0, editable.length(), CharacterStyle.class)) {
            existingSpans.add(new StyleContainer(editable.getSpanStart((Object)parcelableSpan), editable.getSpanEnd((Object)parcelableSpan), (CharacterStyle)parcelableSpan, editable.getSpanFlags((Object)parcelableSpan)));
        }
        try {
            editable.clearSpans();
        }
        catch (Exception exception) {
            // empty catch block
        }
        int iconStart = -1;
        for (int i = 0; i < editable.length(); ++i) {
            StyleContainer styleContainer;
            Character c = Character.valueOf(editable.charAt(i));
            if (c.charValue() == ICON_START) {
                iconStart = i;
                continue;
            }
            if (c.charValue() != ICON_END) continue;
            if (iconStart > -1 && (styleContainer = IconicsUtils.placeFontIcon(editable, iconStart, i, fonts)) != null) {
                styleContainers.add(styleContainer);
                for (StyleContainer existingStyleContainer : existingSpans) {
                    if (existingStyleContainer.startIndex > i) {
                        existingStyleContainer.startIndex -= i - iconStart;
                        existingStyleContainer.endIndex -= i - iconStart;
                        continue;
                    }
                    if (existingStyleContainer.endIndex <= i) continue;
                    existingStyleContainer.endIndex -= i - iconStart;
                }
                i = iconStart;
            }
            iconStart = -1;
        }
        styleContainers.addAll(existingSpans);
        return styleContainers;
    }

    private static StyleContainer placeFontIcon(Editable editable, int iconStart, int iconEnd, HashMap<String, ITypeface> fonts) {
        if (iconEnd - iconStart >= 6) {
            String iconString = editable.subSequence(iconStart + 1, iconEnd).toString().replace("-", "_");
            String fontKey = editable.subSequence(iconStart + 1, iconStart + 4).toString();
            try {
                ITypeface typeface = fonts.get(fontKey);
                if (typeface != null) {
                    IIcon icon = typeface.getIcon(iconString);
                    if (icon != null) {
                        char fontChar = icon.getCharacter();
                        editable.replace(iconStart, iconEnd + 1, (CharSequence)String.valueOf(fontChar));
                        return new StyleContainer(iconStart, iconStart + 1, iconString, fonts.get(fontKey));
                    }
                    Log.e((String)Iconics.TAG, (String)("Wrong icon name: " + iconString));
                } else {
                    Log.e((String)Iconics.TAG, (String)("Wrong fontId: " + iconString));
                }
            }
            catch (IllegalArgumentException e) {
                Log.e((String)Iconics.TAG, (String)("Wrong icon name: " + iconString));
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public static TextStyleContainer findIcons(Spanned spannable, HashMap<String, ITypeface> fonts) {
        void var7_12;
        LinkedList<StyleContainer> styleContainers = new LinkedList<StyleContainer>();
        LinkedList<StyleContainer> existingSpans = new LinkedList<StyleContainer>();
        for (ParcelableSpan parcelableSpan : (ParcelableSpan[])spannable.getSpans(0, spannable.length(), ParcelableSpan.class)) {
            existingSpans.add(new StyleContainer(spannable.getSpanStart((Object)parcelableSpan), spannable.getSpanEnd((Object)parcelableSpan), parcelableSpan, spannable.getSpanFlags((Object)parcelableSpan)));
        }
        for (ParcelableSpan parcelableSpan : (CharacterStyle[])spannable.getSpans(0, spannable.length(), CharacterStyle.class)) {
            existingSpans.add(new StyleContainer(spannable.getSpanStart((Object)parcelableSpan), spannable.getSpanEnd((Object)parcelableSpan), (CharacterStyle)parcelableSpan, spannable.getSpanFlags((Object)parcelableSpan)));
        }
        SpannableStringBuilder spannedString = new SpannableStringBuilder();
        SpannableStringBuilder tempIconString = new SpannableStringBuilder();
        int removedChars = 0;
        boolean bl = false;
        while (var7_12 < spannable.length()) {
            Character c = Character.valueOf(spannable.charAt((int)var7_12));
            if (c.charValue() == ICON_START) {
                spannedString.append((CharSequence)tempIconString);
                tempIconString = new SpannableStringBuilder();
                tempIconString.append(c.charValue());
            } else if (c.charValue() == ICON_END) {
                tempIconString.append(c.charValue());
                if (tempIconString.length() > 5) {
                    StyleContainer styleContainer = IconicsUtils.placeFontIcon(spannedString, tempIconString, fonts);
                    if (styleContainer != null) {
                        styleContainers.add(styleContainer);
                        for (StyleContainer existingStyleContainer : existingSpans) {
                            if (existingStyleContainer.startIndex > var7_12 - removedChars) {
                                existingStyleContainer.startIndex = existingStyleContainer.startIndex - tempIconString.length() + 1;
                            }
                            if (existingStyleContainer.endIndex <= var7_12 - removedChars) continue;
                            existingStyleContainer.endIndex = existingStyleContainer.endIndex - tempIconString.length() + 1;
                        }
                        removedChars += tempIconString.length() - 1;
                    }
                } else {
                    spannedString.append((CharSequence)tempIconString);
                }
                tempIconString = new SpannableStringBuilder();
            } else if (tempIconString.length() == 0) {
                spannedString.append(c.charValue());
            } else {
                tempIconString.append(c.charValue());
            }
            ++var7_12;
        }
        spannedString.append((CharSequence)tempIconString);
        styleContainers.addAll(existingSpans);
        return new TextStyleContainer(spannedString, styleContainers);
    }

    private static StyleContainer placeFontIcon(SpannableStringBuilder spannedString, SpannableStringBuilder tempIconString, HashMap<String, ITypeface> fonts) {
        if (tempIconString.length() >= 6) {
            String iconString = tempIconString.subSequence(1, tempIconString.length() - 1).toString().replace("-", "_");
            String fontKey = tempIconString.subSequence(1, 4).toString();
            try {
                ITypeface typeface = fonts.get(fontKey);
                if (typeface != null) {
                    IIcon icon = typeface.getIcon(iconString);
                    if (icon != null) {
                        char fontChar = icon.getCharacter();
                        spannedString.append(fontChar);
                        return new StyleContainer(spannedString.length() - 1, spannedString.length(), iconString, fonts.get(fontKey));
                    }
                    Log.e((String)Iconics.TAG, (String)("Wrong icon name: " + iconString));
                } else {
                    Log.e((String)Iconics.TAG, (String)("Wrong fontId: " + iconString));
                }
            }
            catch (IllegalArgumentException e) {
                Log.e((String)Iconics.TAG, (String)("Wrong icon name: " + iconString));
            }
        }
        spannedString.append((CharSequence)tempIconString);
        return null;
    }

    public static void applyStyles(Context ctx, Spannable text, List<StyleContainer> styleContainers, List<CharacterStyle> styles, HashMap<String, List<CharacterStyle>> stylesFor) {
        for (StyleContainer styleContainer : styleContainers) {
            if (styleContainer.style != null) {
                text.setSpan((Object)styleContainer.style, styleContainer.startIndex, styleContainer.endIndex, styleContainer.flags);
            } else if (styleContainer.span != null) {
                text.setSpan((Object)styleContainer.span, styleContainer.startIndex, styleContainer.endIndex, styleContainer.flags);
            } else {
                text.setSpan((Object)new IconicsTypefaceSpan("sans-serif", styleContainer.font.getTypeface(ctx)), styleContainer.startIndex, styleContainer.endIndex, 33);
            }
            if (stylesFor != null && stylesFor.containsKey(styleContainer.icon)) {
                for (CharacterStyle style : stylesFor.get(styleContainer.icon)) {
                    text.setSpan((Object)CharacterStyle.wrap((CharacterStyle)style), styleContainer.startIndex, styleContainer.endIndex, styleContainer.flags);
                }
                continue;
            }
            if (styles == null) continue;
            for (CharacterStyle style : styles) {
                text.setSpan((Object)CharacterStyle.wrap((CharacterStyle)style), styleContainer.startIndex, styleContainer.endIndex, styleContainer.flags);
            }
        }
    }
}

