/*
 * Decompiled with CFR 0.152.
 */
package com.mikepenz.iconics.utils;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.StateListDrawable;
import android.support.annotation.StyleableRes;
import android.util.DisplayMetrics;
import android.util.TypedValue;

public class Utils {
    public static int convertDpToPx(Context context, float dp) {
        return (int)TypedValue.applyDimension((int)1, (float)dp, (DisplayMetrics)context.getResources().getDisplayMetrics());
    }

    public static String getString(TypedArray a, @StyleableRes int index, @StyleableRes int defIndex) {
        if (a.hasValue(index)) {
            return a.getString(index);
        }
        return a.getString(defIndex);
    }

    public static StateListDrawable getCheckableIconStateList(Context ctx, Drawable icon, Drawable checkedIcon) {
        return Utils.getCheckableIconStateList(ctx, icon, checkedIcon, true);
    }

    public static StateListDrawable getCheckableIconStateList(Context ctx, Drawable icon, Drawable checkedIcon, boolean animate) {
        StateListDrawable iconStateListDrawable = new StateListDrawable();
        iconStateListDrawable.addState(new int[]{0x10100A0}, checkedIcon);
        iconStateListDrawable.addState(new int[]{-16842912}, icon);
        if (animate) {
            int duration = ctx.getResources().getInteger(0x10E0000);
            iconStateListDrawable.setEnterFadeDuration(duration);
            iconStateListDrawable.setExitFadeDuration(duration);
        }
        return iconStateListDrawable;
    }
}

