/*
 * Decompiled with CFR 0.152.
 */
package com.mitchellbosecke.pebble.extension.core;

import com.mitchellbosecke.pebble.extension.Filter;
import com.mitchellbosecke.pebble.template.EvaluationContext;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class DateFilter
implements Filter {
    private final List<String> argumentNames = new ArrayList<String>();

    public DateFilter() {
        this.argumentNames.add("format");
        this.argumentNames.add("existingFormat");
    }

    @Override
    public List<String> getArgumentNames() {
        return this.argumentNames;
    }

    @Override
    public Object apply(Object input, Map<String, Object> args) {
        if (input == null) {
            return null;
        }
        Date date = null;
        SimpleDateFormat existingFormat = null;
        SimpleDateFormat intendedFormat = null;
        EvaluationContext context = (EvaluationContext)args.get("_context");
        Locale locale = context.getLocale();
        intendedFormat = new SimpleDateFormat((String)args.get("format"), locale);
        if (args.get("existingFormat") != null) {
            existingFormat = new SimpleDateFormat((String)args.get("existingFormat"), locale);
            try {
                date = existingFormat.parse((String)input);
            }
            catch (ParseException e) {
                throw new RuntimeException("Could not parse date", e);
            }
        } else {
            date = (Date)input;
        }
        return intendedFormat.format(date);
    }
}

